/*
 * Decompiled with CFR 0.152.
 */
package com.neurosky.thinkgear;

import android.util.Log;
import com.neurosky.thinkgear.DistanceArray;
import com.neurosky.thinkgear.EkgEpoch;
import com.neurosky.thinkgear.Matlab;
import com.neurosky.thinkgear.TGDevice;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class EkgTemplate {
    public String subjectName;
    public String fileName;
    public EkgEpoch[] templateArray;
    public int maxNumberOfTemplateElements = 100;
    public int lastTemplateIndex;
    public float score;
    public float meanDistance;

    public EkgTemplate(String string2) {
        this.subjectName = string2;
        this.templateArray = new EkgEpoch[this.maxNumberOfTemplateElements];
        this.lastTemplateIndex = 0;
    }

    public EkgTemplate() {
        this.subjectName = "";
        this.templateArray = new EkgEpoch[this.maxNumberOfTemplateElements];
        this.lastTemplateIndex = 0;
    }

    public boolean loadJson(String string2) {
        if (string2.length() == 0) {
            return false;
        }
        try {
            string2 = new JSONTokener(string2);
            string2 = (JSONObject)string2.nextValue();
            this.templateArray = new EkgEpoch[this.maxNumberOfTemplateElements];
            JSONArray jSONArray = string2.getJSONArray("templateArray");
            Log.v((String)"TGDevice", (String)("loadJson() a.length " + jSONArray.length()));
            int n = 0;
            while (n < jSONArray.length()) {
                this.templateArray[n] = new EkgEpoch(jSONArray.getJSONArray(n));
                this.lastTemplateIndex = n++;
            }
            this.subjectName = string2.getString("subjectName");
        }
        catch (JSONException jSONException) {
            Log.d((String)"EkgParameters", (String)("JSON exception: " + jSONException.getLocalizedMessage()));
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    public String toJSONString() {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        Log.v((String)"TGDevice", (String)("toJSONString() template array: " + this.templateArray.length));
        for (int i = 0; i < this.lastTemplateIndex; ++i) {
            jSONArray.put((Object)this.templateArray[i].toJSONArray());
        }
        Log.v((String)"TGDevice", (String)("toJsonString() arraylength:" + jSONArray.length()));
        try {
            jSONObject.accumulate("subjectName", (Object)this.subjectName);
            jSONObject.accumulate("templateArray", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    public float[][] getValues() {
        float[][] fArray = new float[this.lastTemplateIndex][this.templateArray[1].numberOfSamples];
        for (int i = 0; i < this.lastTemplateIndex; ++i) {
            fArray[i] = this.templateArray[i].data;
        }
        return fArray;
    }

    public void addTemplate(int n, float[] fArray) {
        this.templateArray[this.lastTemplateIndex] = new EkgEpoch(n, fArray);
        ++this.lastTemplateIndex;
    }

    public EkgTemplate(String string2, float[][] fArray) {
        this.lastTemplateIndex = 0;
        this.templateArray = new EkgEpoch[this.maxNumberOfTemplateElements];
        this.subjectName = string2;
        for (int i = 0; i < fArray.length; ++i) {
            this.addTemplate(fArray[0].length, fArray[i]);
        }
        this.meanDistance = this.computeDistance(this).mean();
    }

    public void addData(EkgEpoch ekgEpoch) {
        this.templateArray[this.lastTemplateIndex] = ekgEpoch;
        ++this.lastTemplateIndex;
    }

    public void selectRows(int[] nArray) {
        Arrays.sort(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            this.templateArray[i] = this.templateArray[nArray[i]];
        }
        this.lastTemplateIndex = nArray.length;
    }

    public void addTemplate(EkgEpoch ekgEpoch) {
        this.templateArray[this.lastTemplateIndex] = ekgEpoch;
        ++this.lastTemplateIndex;
    }

    public void rmTemplate(int n) {
        while (n < this.lastTemplateIndex - 1) {
            this.copyTemplate(n, n + 1);
            ++n;
        }
        --this.lastTemplateIndex;
    }

    public boolean equal(EkgTemplate ekgTemplate) {
        if (this.lastTemplateIndex != ekgTemplate.lastTemplateIndex) {
            return false;
        }
        for (int i = 0; i < this.lastTemplateIndex; ++i) {
            if (this.templateArray[i].data[0] == ekgTemplate.templateArray[i].data[0]) continue;
            return false;
        }
        return true;
    }

    public static String buildStrongTemplate(String[] stringArray) {
        if (!TGDevice.ekgPersonalizationEnabled) {
            return null;
        }
        EkgTemplate[] ekgTemplateArray = new EkgTemplate[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ekgTemplateArray[i] = new EkgTemplate();
            ekgTemplateArray[i].loadJson(stringArray[i]);
        }
        EkgTemplate ekgTemplate = EkgTemplate.buildStrongTemplate(ekgTemplateArray);
        return ekgTemplate.toJSONString();
    }

    public static EkgTemplate buildStrongTemplate(EkgTemplate[] ekgTemplateArray) {
        int n;
        if (!TGDevice.ekgPersonalizationEnabled) {
            return null;
        }
        int n2 = ekgTemplateArray[0].lastTemplateIndex;
        EkgTemplate ekgTemplate = new EkgTemplate(ekgTemplateArray[0].subjectName);
        if (n2 != ekgTemplateArray.length && ekgTemplateArray[n2] != null | ekgTemplateArray[n2 - 1] == null) {
            throw new Exception("There must be as many element in the cell array as element in each template");
        }
        Object object = new EkgTemplate("test");
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < ekgTemplateArray[i].lastTemplateIndex; ++n) {
                ((EkgTemplate)object).addTemplate(ekgTemplateArray[i].templateArray[n]);
            }
        }
        DistanceArray distanceArray = ((EkgTemplate)object).computeDistance((EkgTemplate)object);
        for (n = 0; n < n2; ++n) {
            object = Matlab.linspace(n * n2, (n + 1) * n2 - 1, n2);
            Object[] objectArray = Matlab.linspace(0, n2 * n2 - 1, n2 * n2);
            objectArray = Matlab.setdiff(objectArray, (int[])object);
            object = distanceArray.subArray((int[])object, (int[])objectArray);
            float[] fArray = ((DistanceArray)object).colMean();
            object = fArray;
            float[] fArray2 = (float[])fArray.clone();
            objectArray = fArray2;
            Arrays.sort(fArray2);
            object = Matlab.sortIndices((float[])object, objectArray);
            int n3 = (int)Math.ceil((double)n2 / 2.0);
            ekgTemplate.addData(ekgTemplateArray[n].templateArray[object[n3 - 1]]);
        }
        return ekgTemplate;
    }

    public DistanceArray computeDistance(EkgTemplate ekgTemplate) {
        if (!TGDevice.ekgPersonalizationEnabled) {
            return null;
        }
        DistanceArray distanceArray = new DistanceArray(this.lastTemplateIndex, ekgTemplate.lastTemplateIndex);
        boolean bl = false;
        if (this.equal(ekgTemplate)) {
            bl = true;
        }
        for (int i = 0; i < this.lastTemplateIndex; ++i) {
            int n;
            if (bl) {
                for (n = i + 1; n < ekgTemplate.lastTemplateIndex; ++n) {
                    try {
                        distanceArray.array[i][n] = (float)Math.sqrt(this.templateArray[i].subtract(ekgTemplate.templateArray[n]).square().mean());
                        distanceArray.array[n][i] = distanceArray.array[i][n];
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Log.v((String)"TGDevice", (String)("ind1: " + i + " ind2: " + n));
                        Log.v((String)"TGDevice", (String)("templateArray Length: " + this.templateArray.length));
                    }
                }
                continue;
            }
            for (n = 0; n < ekgTemplate.lastTemplateIndex; ++n) {
                distanceArray.array[i][n] = (float)Math.sqrt(this.templateArray[i].subtract(ekgTemplate.templateArray[n]).square().mean());
            }
        }
        return distanceArray;
    }

    public void copyTemplate(int n, int n2) {
        for (int i = 0; i < this.lastTemplateIndex; ++i) {
            this.templateArray[n] = this.templateArray[n2].clone();
        }
    }
}

