/*
 * Decompiled with CFR 0.152.
 */
package com.neurosky.thinkgear;

import android.util.Log;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;

public class EkgEpoch
implements Cloneable {
    public int numberOfSamples;
    public float[] data;

    public EkgEpoch(int n) {
        this.numberOfSamples = n;
        this.data = new float[this.numberOfSamples];
    }

    public EkgEpoch(int n, float[] fArray) {
        this.numberOfSamples = n;
        this.data = new float[this.numberOfSamples];
        System.arraycopy(fArray, 0, this.data, 0, this.numberOfSamples);
    }

    public EkgEpoch(float[] fArray) {
        this.numberOfSamples = fArray.length;
        this.data = new float[this.numberOfSamples];
        System.arraycopy(fArray, 0, this.data, 0, this.numberOfSamples);
    }

    public EkgEpoch(EkgEpoch ekgEpoch) {
        this.numberOfSamples = ekgEpoch.numberOfSamples;
        this.data = new float[this.numberOfSamples];
        System.arraycopy(ekgEpoch.data, 0, this.data, 0, this.numberOfSamples);
    }

    public EkgEpoch(JSONArray jSONArray) {
        this.numberOfSamples = jSONArray.length();
        this.data = new float[this.numberOfSamples];
        try {
            for (int i = 0; i < this.numberOfSamples; ++i) {
                this.data[i] = (float)jSONArray.getDouble(i);
            }
            return;
        }
        catch (JSONException jSONException) {
            Log.d((String)"EkgEpoch", (String)("JSON exception: " + jSONException.getLocalizedMessage()));
            return;
        }
    }

    public JSONArray toJSONArray() {
        JSONArray jSONArray = new JSONArray();
        float[] fArray = this.data;
        int n = this.data.length;
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            try {
                jSONArray.put((double)f);
                continue;
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
        }
        return jSONArray;
    }

    public static float[] convolve(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length + fArray2.length - 1];
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                int n = i + j;
                fArray3[n] = fArray3[n] + fArray2[i] * fArray[j];
            }
        }
        return fArray3;
    }

    public boolean detectHighTail(int n) {
        boolean bl = false;
        int n2 = this.data.length / 2;
        int n3 = n2 + 1;
        if (++n < n2) {
            if (this.exceedValue(this.data[n3 - 1], 0, n2 - n)) {
                bl = true;
            }
        } else if (this.exceedValue(this.data[n3 - 1], this.data.length - (n2 - (2 * n2 - n)) - 1, this.data.length)) {
            bl = true;
        }
        return bl;
    }

    public float getLineNoiseAmplitude() {
        EkgEpoch ekgEpoch = this.subtract(this.mean());
        float[] fArray = new float[13];
        float[] fArray2 = new float[13];
        for (int i = 0; i < 13; ++i) {
            float f = (float)((double)(2 * i) * Math.PI / 13.0);
            fArray[i] = (float)Math.cos(f * 2.0f);
            fArray2[i] = (float)Math.sin(f * 2.0f);
        }
        float[] fArray3 = EkgEpoch.convolve(ekgEpoch.data, fArray);
        float[] fArray4 = EkgEpoch.convolve(ekgEpoch.data, fArray2);
        float f = 0.0f;
        for (int i = 0; i < fArray3.length; ++i) {
            f = (float)((double)f + Math.sqrt(fArray3[i] * fArray3[i] + fArray4[i] * fArray4[i]));
        }
        return f;
    }

    public EkgEpoch subtract(EkgEpoch ekgEpoch) {
        EkgEpoch ekgEpoch2 = new EkgEpoch(this.numberOfSamples);
        for (int i = 0; i < this.numberOfSamples; ++i) {
            ekgEpoch2.data[i] = this.data[i] - ekgEpoch.data[i];
        }
        return ekgEpoch2;
    }

    public EkgEpoch subEpoch(int n, int n2) {
        EkgEpoch ekgEpoch = new EkgEpoch(n2 - n);
        for (int i = n; i < n2; ++i) {
            ekgEpoch.data[i - n] = this.data[i];
        }
        return ekgEpoch;
    }

    public EkgEpoch subEpoch2(int n, int n2, int n3, int n4) {
        EkgEpoch ekgEpoch = new EkgEpoch(n2 - n + n4 - n3);
        int n5 = 0;
        while (n < n2) {
            ekgEpoch.data[n5++] = this.data[n];
            ++n;
        }
        for (n = n3; n < n4; ++n) {
            ekgEpoch.data[n5++] = this.data[n];
        }
        return ekgEpoch;
    }

    public EkgEpoch square() {
        EkgEpoch ekgEpoch = new EkgEpoch(this.numberOfSamples);
        for (int i = 0; i < this.numberOfSamples; ++i) {
            ekgEpoch.data[i] = this.data[i] * this.data[i];
        }
        return ekgEpoch;
    }

    public EkgEpoch subtract(float f) {
        EkgEpoch ekgEpoch = new EkgEpoch(this.numberOfSamples);
        for (int i = 0; i < this.numberOfSamples; ++i) {
            ekgEpoch.data[i] = this.data[i] - f;
        }
        return ekgEpoch;
    }

    public EkgEpoch diff() {
        EkgEpoch ekgEpoch = new EkgEpoch(this.numberOfSamples - 1);
        for (int i = 0; i < ekgEpoch.numberOfSamples; ++i) {
            ekgEpoch.data[i] = this.data[i + 1] - this.data[i];
        }
        return ekgEpoch;
    }

    public boolean exceedValue(float f, int n, int n2) {
        while (n < n2) {
            if (this.data[n] > f) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public EkgEpoch smooth(int n) {
        EkgEpoch ekgEpoch = new EkgEpoch(this.numberOfSamples);
        if ((float)Math.round((float)n / 2.0f) == (float)n / 2.0f) {
            --n;
        }
        int n2 = 0;
        while (n2 < ekgEpoch.numberOfSamples) {
            int n3 = Math.min(Math.min(n2, n / 2), ekgEpoch.numberOfSamples - n2 - 1);
            int n4 = (n3 << 1) + 1;
            for (int i = -n3; i < n3 + 1; ++i) {
                int n5 = n2;
                ekgEpoch.data[n5] = ekgEpoch.data[n5] + this.data[n2 + i];
            }
            int n6 = n2++;
            ekgEpoch.data[n6] = ekgEpoch.data[n6] / (float)n4;
        }
        return ekgEpoch;
    }

    public float mean() {
        return this.sum() / (float)this.numberOfSamples;
    }

    public float sum() {
        float f = 0.0f;
        for (int i = 0; i < this.numberOfSamples; ++i) {
            f += this.data[i];
        }
        return f;
    }

    public float max() {
        float f = 0.0f;
        for (int i = 0; i < this.numberOfSamples; ++i) {
            if (!(this.data[i] > f)) continue;
            f = this.data[i];
        }
        return f;
    }

    public float median() {
        float[] fArray = new float[this.numberOfSamples];
        for (int i = 0; i < this.numberOfSamples; ++i) {
            fArray[i] = this.data[i];
        }
        Arrays.sort(fArray);
        if (Math.floor(this.numberOfSamples / 2) * 2.0 == (double)this.numberOfSamples) {
            return (fArray[(int)Math.ceil(this.numberOfSamples / 2) - 1] + fArray[(int)Math.ceil(this.numberOfSamples / 2)]) / 2.0f;
        }
        return fArray[(int)Math.ceil(this.numberOfSamples / 2)];
    }

    public EkgEpoch clone() {
        try {
            return (EkgEpoch)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public EkgEpoch sort() {
        EkgEpoch ekgEpoch = new EkgEpoch(this);
        Arrays.sort(ekgEpoch.data);
        return ekgEpoch;
    }

    public int[] sortIndices(EkgEpoch ekgEpoch) {
        int[] nArray = new int[this.numberOfSamples];
        block0: for (int i = 0; i < this.numberOfSamples; ++i) {
            for (int j = 0; j < this.numberOfSamples; ++j) {
                if (this.data[i] != ekgEpoch.data[j]) continue;
                nArray[j] = i;
                continue block0;
            }
        }
        return nArray;
    }

    public float std() {
        float f = 0.0f;
        float f2 = this.mean();
        for (int i = 0; i < this.numberOfSamples; ++i) {
            f += (this.data[i] - f2) * (this.data[i] - f2);
        }
        return (float)Math.sqrt(f / (float)(this.numberOfSamples - 1));
    }

    public int find_heart_beats(int[] nArray, float f) {
        int n = Math.abs(nArray[0]);
        int n2 = nArray[1];
        EkgEpoch ekgEpoch = this.subtract(this.median());
        EkgEpoch ekgEpoch2 = ekgEpoch.diff();
        int n3 = 0;
        float f2 = 0.0f;
        for (int i = n; i < ekgEpoch2.numberOfSamples - n2; ++i) {
            if (!(ekgEpoch2.data[i - 1] > 0.0f & ekgEpoch2.data[i] < 0.0f)) continue;
            float f3 = ekgEpoch.data[i] - ekgEpoch.data[i - n] + (ekgEpoch.data[i] - ekgEpoch.data[i + n2]);
            float f4 = ekgEpoch.data[i + 1] - ekgEpoch.data[i + 1 - n] + (ekgEpoch.data[i + 1] - ekgEpoch.data[i + 1 + n2]);
            if (f3 > f2) {
                f2 = f3;
                n3 = i;
            }
            if (!(f4 > f2)) continue;
            f2 = f4;
            n3 = i + 1;
        }
        if (f2 < f) {
            return -1;
        }
        if ((double)(ekgEpoch.data[n3] - ekgEpoch.data[n3 - n]) < (double)f / 2.8 | ekgEpoch.data[n3] - ekgEpoch.data[n3 + n2] < f / 2.0f) {
            return -1;
        }
        return n3;
    }

    public EkgEpoch detrend() {
        float[] fArray = this.data;
        Object object = new float[this.numberOfSamples];
        int n = this.numberOfSamples;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            object[i] = i;
            f += object[i];
            f2 += fArray[i];
        }
        float f3 = f / (float)n;
        f = f2 / (float)n;
        f2 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 += (object[i] - f3) * (object[i] - f3);
            f4 += (object[i] - f3) * (fArray[i] - f);
        }
        float f5 = f4 / f2;
        float f6 = f - f5 * f3;
        object = new EkgEpoch(this.numberOfSamples);
        for (n = 0; n < object.numberOfSamples; ++n) {
            object.data[n] = this.data[n] - f6 - f5 * (float)n;
        }
        return object;
    }
}

