/*
 * Decompiled with CFR 0.152.
 */
package com.neurosky.thinkgear;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.format.DateFormat;
import android.util.Log;
import com.neurosky.thinkgear.EkgParameters;
import com.neurosky.thinkgear.EkgSenseManager;
import com.neurosky.thinkgear.EkgTemplate;
import com.neurosky.thinkgear.EnergyLevel;
import com.neurosky.thinkgear.Meditation;
import com.neurosky.thinkgear.NeuroSkyHeartMeters;
import com.neurosky.thinkgear.Positivity;
import com.neurosky.thinkgear.RespiratoryRate;
import com.neurosky.thinkgear.TGBlinkDetector;
import com.neurosky.thinkgear.TGEegPower;
import com.neurosky.thinkgear.TGHrv;
import com.neurosky.thinkgear.TGRawMulti;
import com.neurosky.thinkgear.TGSamplingRateCalculator;
import com.neurosky.thinkgear.TGconfig;
import com.neurosky.thinkgear.TaskDifficulty;
import com.neurosky.thinkgear.TaskFamiliarity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class TGDevice {
    public static final int STATE_IDLE = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTED = 3;
    public static final int STATE_NOT_FOUND = 4;
    public static final int STATE_ERR_NO_DEVICE = 5;
    public static final int STATE_ERR_BT_OFF = 6;
    public static final int MSG_STATE_CHANGE = 256;
    public static final int MSG_POOR_SIGNAL = 2;
    public static final int MSG_HEART_RATE = 3;
    public static final int MSG_ATTENTION = 4;
    public static final int MSG_MEDITATION = 5;
    public static final int MSG_EGO_TRIM = 8;
    public static final int MSG_ZONE = 14;
    public static final int MSG_BLINK = 22;
    public static final int MSG_RELAXATION = 24;
    public static final int MSG_RESPIRATION = 25;
    public static final int MSG_POSITIVITY = 26;
    public static final int MSG_FAMILIARITY = 27;
    public static final int MSG_DIFFICULTY = 28;
    public static final int MSG_RAW_DATA = 128;
    public static final int MSG_EEG_POWER = 131;
    public static final int MSG_RAW_MULTI = 145;
    public static final int MSG_THINKCAPBETA_RAW = 176;
    public static final int MSG_THINKCAP_RAW = 177;
    public static final int MSG_SLEEP_STAGE = 178;
    public static final int MSG_MULTI_SIGNAL_STATUS = 179;
    public static final int MSG_RAW_COUNT = 19;
    public static final int MSG_LOW_BATTERY = 20;
    public static final int MSG_EKG_IDENTIFIED = 268;
    public static final int MSG_EKG_TRAINED = 269;
    public static final int MSG_EKG_TRAIN_STEP = 270;
    public static final int MSG_EKG_RRINT = 271;
    public static final int MSG_HEART_AGE = 272;
    public static final int MSG_HEART_AGE_5MIN = 273;
    public int ekgState = 0;
    public static final boolean L = true;
    public static boolean ekgPersonalizationEnabled = false;
    private static final UUID uuid = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    Handler handler;
    private boolean byteLogEnabled = false;
    private boolean logEnabled = false;
    private boolean rawEnabled = false;
    private boolean isReadable;
    private boolean isStart = false;
    private int state;
    private BluetoothAdapter btAdapter;
    private OutputStream output;
    private BluetoothDevice connectedDevice;
    private Set<BluetoothDevice> pairedDevices;
    private ConnectThread btConnectThread;
    private ConnectedThread btConnectedThread;
    private OutputStream logWriter;
    private OutputStream byteLogWriter;
    public EkgSenseManager ekgSenseMan;
    private List<Integer> rrintBuffer;
    private List<Integer> rrintBufferForHeartAge;
    private List<Integer> inputRawBuffer;
    private StreamThread streamThread;
    private InputStream inputstream;
    public int inputAge;
    public int pass_seconds;
    private static int pass_raw_counter = 0;
    public static final int version = 22;
    public static final int minorversion = 106;
    public static final String build_title = "2012-12-14 SDK Release";

    /*
     * WARNING - void declaration
     */
    public TGDevice(BluetoothAdapter btAdapter, Handler handler) {
        void var2_2;
        void var1_1;
        this.btAdapter = var1_1;
        this.handler = var2_2;
        this.state = 0;
        if (ekgPersonalizationEnabled) {
            this.ekgSenseMan = new EkgSenseManager(this);
        }
        this.rrintBuffer = new ArrayList<Integer>();
        this.rrintBufferForHeartAge = new ArrayList<Integer>();
        this.inputRawBuffer = new ArrayList<Integer>();
        TGDevice.logTheVersion();
        if (this.btAdapter.getState() == 10) {
            this.setState(6);
            this.state = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public TGDevice(InputStream s, OutputStream o, Handler handler) {
        void var3_3;
        void var1_1;
        this.state = 0;
        if (s == null) {
            Log.v((String)"TGDevice", (String)"Invalid input stream");
        }
        this.inputstream = var1_1;
        if (o != null) {
            void var2_2;
            this.output = var2_2;
        }
        this.handler = var3_3;
        if (ekgPersonalizationEnabled) {
            this.ekgSenseMan = new EkgSenseManager(this);
        }
        this.rrintBuffer = new ArrayList<Integer>();
        this.rrintBufferForHeartAge = new ArrayList<Integer>();
        this.inputRawBuffer = new ArrayList<Integer>();
        TGDevice.logTheVersion();
    }

    public static int getVersion() {
        return 22;
    }

    public static int getMinorVersion() {
        return 106;
    }

    public static String getTitle() {
        return build_title;
    }

    private static void logTheVersion() {
        Log.d((String)"TGDevice", (String)("Initialized. Version: " + TGDevice.getVersion()));
        if (TGDevice.getVersion() != TGconfig.getVersion()) {
            Log.w((String)"TGDevice", (String)("OOPS!! TG-SDK internal Version mismatch: TGDevice: " + TGDevice.getVersion() + " TGconfig: " + TGconfig.getVersion() + "\n"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void connect(BluetoothDevice btDevice) {
        void var1_1;
        this.connect((BluetoothDevice)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void connect(BluetoothDevice btDevice, boolean rawEnabled) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (this.btAdapter.getState() == 10) {
            this.setState(6);
            return;
        }
        this.setStart(false);
        this.rawEnabled = rawEnabled;
        HashSet<BluetoothDevice> d = new HashSet<BluetoothDevice>();
        d.add(btDevice);
        if (this.btConnectThread != null) {
            this.btConnectThread.cancel();
            this.btConnectThread = null;
        }
        this.btConnectThread = new ConnectThread(this, (Set<BluetoothDevice>)var3_3);
        this.btConnectThread.start();
        this.setState(1);
        Log.i((String)"TGDevice", (String)("Connecting to device: " + var1_1.getName() + " with raw enabled: " + (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void connect(boolean rawEnabled) {
        if (this.btAdapter.getState() == 10) {
            this.setState(6);
            return;
        }
        if (this.btAdapter != null) {
            void var1_1;
            this.setStart(false);
            this.rawEnabled = var1_1;
            this.pairedDevices = this.btAdapter.getBondedDevices();
            if (this.pairedDevices.isEmpty() && this.btConnectThread != null) {
                this.btConnectThread.cancel();
                this.btConnectThread = null;
            }
            this.btConnectThread = new ConnectThread(this, this.pairedDevices);
            this.btConnectThread.start();
            this.setState(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void connectUart(boolean rawEnabled) {
        void var1_1;
        this.connectStream((boolean)var1_1);
    }

    public synchronized void connectStream(boolean bl) {
        if (this.streamThread != null) {
            this.streamThread.cancel();
            this.streamThread = null;
        }
        this.streamThread = new StreamThread(this, this.inputstream);
        this.streamThread.start();
        this.setState(2);
        this.setReadable(true);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void connected(BluetoothSocket btSocket) {
        void var1_1;
        if (this.btConnectThread != null) {
            this.btConnectThread = null;
        }
        if (this.btConnectedThread != null) {
            this.btConnectedThread.cancel();
            this.btConnectedThread = null;
        }
        this.setReadable(true);
        this.btConnectedThread = new ConnectedThread(this, (BluetoothSocket)var1_1, this.rawEnabled);
        this.btConnectedThread.start();
        this.setState(2);
    }

    public synchronized void close() {
        if (this.btConnectThread != null) {
            this.btConnectThread.cancel();
            this.btConnectThread = null;
        }
        if (this.btConnectedThread != null) {
            this.btConnectedThread.cancel();
            this.btConnectedThread = null;
        }
        if (this.streamThread != null) {
            this.streamThread.cancel();
            this.streamThread = null;
        }
        this.stopLog();
        this.setState(3);
        Log.i((String)"TGDevice", (String)"Closing connections");
    }

    public synchronized void start() {
        Log.d((String)"TGDevice", (String)"Starting stream");
        this.setStart(true);
    }

    public synchronized void stop() {
        Log.d((String)"TGDevice", (String)"Stopping stream");
        this.setStart(false);
        this.setState(0);
    }

    public BluetoothDevice getConnectedDevice() {
        return this.connectedDevice;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setState(int s) {
        void var1_1;
        this.state = var1_1;
        this.handler.obtainMessage(256, this.state, 0).sendToTarget();
    }

    public synchronized int getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setReadable(boolean readable) {
        void var1_1;
        this.isReadable = var1_1;
    }

    private synchronized boolean getReadable() {
        return this.isReadable;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setStart(boolean start) {
        void var1_1;
        this.isStart = var1_1;
    }

    private synchronized boolean getStart() {
        return this.isStart;
    }

    /*
     * WARNING - void declaration
     */
    public boolean startLog(String path, String fileName) {
        if (this.logEnabled) {
            return false;
        }
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            if (path == "") {
                path = Environment.getExternalStorageDirectory() + "/Android/data/com.neurosky.thinkgear/files";
            }
            if (fileName == "") {
                fileName = ((Object)DateFormat.format((CharSequence)"yyyy-MM-dd-hhmmss", (Date)new Date())).toString() + ".txt";
            }
            File dir = new File(path);
            File file = new File(path, fileName);
            try {
                void var3_4;
                if (!dir.exists() && var3_4.mkdirs()) {
                    Log.d((String)"TGDevice", (String)"Log directory created successfully");
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                if (file.exists()) {
                    this.logWriter = new FileOutputStream(file);
                    this.logEnabled = true;
                    Log.i((String)"TGDevice", (String)("Logging enabled: " + path + fileName));
                }
            }
            catch (IOException e) {
                void var1_1;
                void var2_3;
                Log.v((String)"TGDevice", (String)("WTF: " + var2_3 + " path: " + (String)var1_1));
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean startByteLog(String path, String fileName) {
        if (this.byteLogEnabled) {
            return false;
        }
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            if (path == "") {
                path = Environment.getExternalStorageDirectory() + "/Android/data/com.neurosky.thinkgear/files";
            }
            if (fileName == "") {
                fileName = ((Object)DateFormat.format((CharSequence)"yyyy-MM-dd-hhmmss", (Date)new Date())).toString() + ".byte.txt";
            }
            File dir = new File(path);
            File file = new File(path, fileName);
            try {
                void var3_4;
                if (!dir.exists() && var3_4.mkdirs()) {
                    Log.d((String)"TGDevice", (String)"Log directory created successfully");
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                if (file.exists()) {
                    this.byteLogWriter = new FileOutputStream(file);
                    this.byteLogEnabled = true;
                    Log.i((String)"TGDevice", (String)(" Byte Logging enabled: " + path + fileName));
                }
            }
            catch (IOException e) {
                void var1_1;
                void var2_3;
                Log.v((String)"TGDevice", (String)("WTF: " + var2_3 + " path: " + (String)var1_1));
                return false;
            }
            return true;
        }
        return false;
    }

    public void stopLog() {
        IOException iOException;
        if (this.logEnabled) {
            this.logEnabled = false;
            try {
                this.logWriter.close();
                Log.i((String)"TGDevice", (String)"Logging disabled");
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                iOException2.printStackTrace();
            }
        }
        if (this.byteLogEnabled) {
            this.byteLogEnabled = false;
            try {
                this.byteLogWriter.close();
                Log.i((String)"TGDevice", (String)"Logging disabled");
                return;
            }
            catch (IOException iOException3) {
                iOException = iOException3;
                iOException3.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public double getHeartAge() {
        void var1_1;
        if (this.rrintBuffer.size() == 0) {
            return -1.0;
        }
        Integer[] t = new Integer[this.rrintBuffer.size()];
        double d = NeuroSkyHeartMeters.calculateHeartAgeRaw((Integer[])((Integer[])this.rrintBuffer.toArray((T[])var1_1)));
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public int getHeartRisk() {
        void var1_1;
        if (this.rrintBuffer.size() == 0) {
            return -1;
        }
        Integer[] t = new Integer[this.rrintBuffer.size()];
        int n = NeuroSkyHeartMeters.calculateHeartRiskAware((Integer[])((Integer[])this.rrintBuffer.toArray((T[])var1_1)));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int EKGloadParams(String name) {
        void var1_1;
        if (!ekgPersonalizationEnabled) {
            return -1;
        }
        if (name.length() == 0) {
            Log.v((String)"TGDevice", (String)"EKG Mode: Indentificiation");
            this.ekgSenseMan.ekgSenseObj.params = new EkgParameters();
            return 0;
        }
        Log.v((String)"TGDevice", (String)"EKG Mode: Authentication");
        this.ekgSenseMan.loadParameterFile((String)var1_1);
        return 1;
    }

    public void EKGstartDetection() {
        if (!ekgPersonalizationEnabled) {
            return;
        }
        this.ekgSenseMan.resetBuffer();
        this.ekgSenseMan.ekgSenseObj.currentData = new EkgTemplate();
        this.ekgState = 3;
    }

    public void EKGstopDetection() {
        if (!ekgPersonalizationEnabled) {
            return;
        }
        this.ekgState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void EKGstartTraining(String userName) {
        void var1_1;
        if (!ekgPersonalizationEnabled) {
            return;
        }
        this.ekgState = 1;
        this.ekgSenseMan.learnName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void EKGstartLongTraining(String userName) {
        void var1_1;
        if (!ekgPersonalizationEnabled) {
            return;
        }
        this.ekgState = 2;
        this.ekgSenseMan.ekgSenseObj.reset();
        this.ekgSenseMan.learnName = var1_1;
        this.ekgSenseMan.learnCounter = 0;
    }

    public void EKGstopTraining() {
        if (!ekgPersonalizationEnabled) {
            return;
        }
        this.ekgState = 0;
        this.ekgSenseMan.learnName = "";
    }

    public boolean EKGdeleteUser(String name) {
        if (!ekgPersonalizationEnabled) {
            return false;
        }
        File dir = new File(Environment.getExternalStorageDirectory() + "/Android/data/com.neurosky.thinkgear/files/EKG/templates");
        String[] fileNames = dir.list();
        if (fileNames != null) {
            String[] arr$ = fileNames;
            int len$ = fileNames.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File file;
                String n = arr$[i$];
                if (!n.startsWith(name + ".json") || !(file = new File(dir, n)).delete()) continue;
                Log.v((String)"TGDevice", (String)("Deleted file: " + n));
                this.ekgSenseMan.loadTemplates();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(TGDevice x0, int x1) {
        void var1_1;
        x0.setState((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BluetoothDevice access$302(TGDevice x0, BluetoothDevice x1) {
        void var1_1;
        x0.connectedDevice = var1_1;
        return x0.connectedDevice;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(TGDevice x0, BluetoothSocket x1) {
        void var1_1;
        x0.connected((BluetoothSocket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ OutputStream access$502(TGDevice x0, OutputStream x1) {
        void var1_1;
        x0.output = var1_1;
        return x0.output;
    }

    static /* synthetic */ boolean access$900(TGDevice x0) {
        return x0.logEnabled;
    }

    static /* synthetic */ void access$1000(TGDevice x0, String x1) {
        Object object = x0;
        if (((TGDevice)object).logEnabled) {
            String string;
            string = System.currentTimeMillis() + ": " + string + '\r';
            try {
                ((TGDevice)object).logWriter.write(string.getBytes());
                return;
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
        }
    }

    static /* synthetic */ List access$1100(TGDevice x0) {
        return x0.rrintBuffer;
    }

    static /* synthetic */ List access$1200(TGDevice x0) {
        return x0.rrintBufferForHeartAge;
    }

    static /* synthetic */ List access$1300(TGDevice x0) {
        return x0.inputRawBuffer;
    }

    static /* synthetic */ int access$1402(int n) {
        pass_raw_counter = 0;
        return 0;
    }

    static /* synthetic */ int access$1408() {
        return pass_raw_counter++;
    }

    static /* synthetic */ int access$1400() {
        return pass_raw_counter;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1500(TGDevice x0, byte[] x1) {
        Object object = x0;
        try {
            if (((TGDevice)object).output != null) {
                void var1_1;
                ((TGDevice)object).output.write((byte[])var1_1);
            }
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    private final class TGParser {
        private Handler handler;
        private boolean hwHeartRateEnabled = false;
        private boolean rawCountEnabled = false;
        private boolean sineWaveEnabled = false;
        private boolean trimByteSent = false;
        private boolean isBMD101 = true;
        private boolean respirationEnabled = true;
        private boolean blinkEnabled = false;
        private boolean sleepStageEnabled = false;
        private boolean relaxationEnabled = true;
        private boolean rawEnabled;
        private boolean familiarityEnabled = false;
        private boolean difficultyEnabled = false;
        private boolean timeBasedIntervalEnabled = true;
        private boolean calculationEnabled = false;
        private int parserState;
        private int payloadLength;
        private int payloadBytesReceived;
        private int payloadSum;
        private int checksum;
        private int rawCount = 0;
        private byte[] payload = new byte[256];
        private int[] sine = new int[512];
        private double[] coeff = new double[]{-9.7440442358423E-5, -1.1588027064266E-4, -1.68411968763922E-4, -2.20230946712853E-4, -2.61497617618105E-4, -2.80928519745322E-4, -2.66503975879537E-4, -2.07456105101242E-4, -9.60607754678275E-5, 7.06479844998841E-5, 2.89279202398974E-4, 5.49359171310485E-4, 8.33627498869421E-4, 0.00111885157865328, 0.0013781195000037, 0.00158354624155544, 0.00170981291692959, 0.00173740932884499, 0.00165575166183813, 0.00146506438032912, 0.00117746477759056, 8.16034117695199E-4, 4.12844215447331E-4, 5.24895417994034E-6, -3.68302018467704E-4, -6.73193852496632E-4, -8.82833781720179E-4, -9.82353338460868E-4, -9.70341482030938E-4, -8.59260495804291E-4, -6.73493754692806E-4, -4.46146123317908E-4, -2.14182662702644E-4, -1.34624881903889E-5, 1.26516426775505E-4, 1.86466300968715E-4, 1.60107470556599E-4, 5.45352349753129E-5, -1.10987588308181E-4, -3.08509874719252E-4, -5.05715502523139E-4, -6.71317451493218E-4, -7.79750742743636E-4, -8.15365828849824E-4, -7.74523301469025E-4, -6.66185490192942E-4, -5.10005871163562E-4, -3.33137954084399E-4, -1.65400913899566E-4, -3.45312065837977E-5, 3.86308033064396E-5, 4.32881937489408E-5, -1.94228353791984E-5, -1.37026795703571E-4, -2.87767026596535E-4, -4.44674887956967E-4, -5.80032844849327E-4, -6.7039277429577E-4, -7.00350679062249E-4, -6.65360053537445E-4, -5.72186532290299E-4, -4.37843807718034E-4, -2.86293068422389E-4, -1.44403231408916E-4, -3.69617246459944E-5, 1.74584888808446E-5, 9.98070420727893E-6, -5.7277674807016E-5, -1.71410449954226E-4, -3.11303641234571E-4, -4.51218621755097E-4, -5.65653686021656E-4, -6.33691820405254E-4, -6.42981223594934E-4, -5.9171601394605E-4, -4.89172991016836E-4, -3.5379923287896E-4, -2.10096448291764E-4, -8.39458869442319E-5, 1.8664996724834E-6, 3.20306720584621E-5, 1.28683042804457E-6, -8.43683732439765E-5, -2.08973511855545E-4, -3.49264936862277E-4, -4.79138906517235E-4, -5.74195668379932E-4, -6.1644929580642E-4, -5.97431437802573E-4, -5.20018323470526E-4, -3.97735963103583E-4, -2.5255457870159E-4, -1.10666382579362E-4, 2.08912857755044E-6, 6.52221969033149E-5, 6.71888260706398E-5, 7.8132740985481E-6, -1.01816886829692E-4, -2.41089628777638E-4, -3.83829338777272E-4, -5.02871887665066E-4, -5.75313621310307E-4, -5.86569142963063E-4, -5.33373583604141E-4, -4.24271089806838E-4, -2.78364015955548E-4, -1.21647686322812E-4, 1.75247095049829E-5, 1.13908852304928E-4, 1.49870978174831E-4, 1.18971164016274E-4, 2.70624688829392E-5, -1.08442383216512E-4, -2.61904280504075E-4, -4.03915938898268E-4, -5.06955565217396E-4, -5.50312187666917E-4, -5.24244802280253E-4, -4.31708214571715E-4, -2.88174788977175E-4, -1.18683678206045E-4, 4.64904244119377E-5, 1.77638742212356E-4, 2.50946901093621E-4, 2.5323129899956E-4, 1.84316204896415E-4, 5.74523943528654E-5, -1.03198447100559E-4, -2.66713802736679E-4, -4.01313076289361E-4, -4.80063170756953E-4, -4.86191446429637E-4, -4.16139661135309E-4, -2.80623721390072E-4, -1.02610485587946E-4, 8.65917343263471E-5, 2.53285447950829E-4, 3.67434261574489E-4, 4.08543598287131E-4, 3.69410870378961E-4, 2.57871342545317E-4, 9.53324649004418E-5, -8.68245287093865E-5, -2.53184359458119E-4, -3.70652605605774E-4, -4.14892907150544E-4, -3.74794893114052E-4, -2.54954924592149E-4, -7.48344639902692E-5, 1.34455506846221E-4, 3.36015790834792E-4, 4.93770262973607E-4, 5.79439273810329E-4, 5.77738539851612E-4, 4.8963925032985E-4, 3.3221821078459E-4, 1.35904911184024E-4, -6.12246546286886E-5, -2.20256642442962E-4, -3.08920034466907E-4, -3.07522853427615E-4, -2.13033893593434E-4, -3.96953994968743E-5, 1.83180508682799E-4, 4.16678727825662E-4, 6.19220331665681E-4, 7.54513329299535E-4, 7.982248319367E-4, 7.42921251348084E-4, 5.99512281288621E-4, 3.95685490536059E-4, 1.70770556774819E-4, -3.12520579316764E-5, -1.70122935327124E-4, -2.16702229081013E-4, -1.58799772313772E-4, -3.51663112894297E-6, 2.23593185867299E-4, 4.83230524813043E-4, 7.2930778548967E-4, 9.17680849208474E-4, 0.00101425160569053, 0.00100170797231571, 8.82824811935392E-4, 6.80444821457835E-4, 4.33304948104277E-4, 1.89211708760537E-4, -3.97963442099545E-6, -1.0714149456976E-4, -9.75382510211861E-5, 2.68551602843451E-5, 2.464637750764E-4, 5.2364554256276E-4, 8.09281106655558E-4, 0.00105200093732304, 0.00120759179058643, 0.00124758803351198, 0.0011646592200388, 9.74496584720574E-4, 7.13031741195615E-4, 4.30193817156114E-4, 1.80569079914348E-4, 1.34194308769052E-5, -3.68288426928038E-5, 4.29148478210438E-5, 2.41435399013574E-4, 5.25127275789142E-4, 8.43769833829344E-4, 0.00113987720111445, 0.00135918714255885, 0.00146107399744823, 0.00142619655393134, 0.00126063555002634, 9.94960964833502E-4, 6.79052557660961E-4, 3.72855678084063E-4, 1.35466757159849E-4, 1.3849309144843E-5, 3.4012343541018E-5, 1.95625958665316E-4, 4.71854489811893E-4, 8.13805297511983E-4, 0.00115954087382408, 0.00144532357565324, 0.00161772585583283, 0.00164363911682995, 0.00151697631774312, 0.00126005466552864, 9.20018434871427E-4, 5.6019737374658E-4, 2.48641831922795E-4, 4.52472361597781E-5, -9.44217447750788E-6, 9.76836786773469E-5, 3.49587730781208E-4, 7.01646118277693E-4, 0.00108976947205013, 0.00144196301098922, 0.00169189034302864, 0.00179124501034788, 0.00171926753558527, 0.00148689997345125, 0.00113538873580102, 7.28840658240885E-4, 3.42704502465947E-4, 4.9611695770945E-5, -9.41422652072306E-5, -5.95892868598273E-5, 1.49210026530823E-4, 4.95251264637447E-4, 9.15185152311649E-4, 0.00133064261755464, 0.00166288067239408, 0.00184740513073318, 0.00184646637631842, 0.00165640715611924, 0.00130904009040423, 8.66067932635046E-4, 4.08117020837066E-4, 1.9730705769468E-5, -2.26295960430978E-4, -2.8293202316019E-4, -1.37996600502361E-4, 1.82850004396995E-4, 6.20484195280941E-4, 0.00109274642643676, 0.00150966475862766, 0.00179008298063751, 0.00187719780614157, 0.00174946519687166, 0.00142535532397548, 9.60366107007573E-4, 4.37330250865943E-4, -4.88633815893146E-5, -4.08761057604636E-4, -5.75386700363658E-4, -5.17038609916063E-4, -2.43954622688529E-4, 1.93088506220769E-4, 7.11525817673556E-4, 0.0012121573011249, 0.00159738209371754, 0.00178971139213456, 0.00174651275888789, 0.00146872604881992, 0.00100124647033075, 4.25335294937135E-4, -1.56208575877302E-4, -6.37884782523169E-4, -9.31420112254212E-4, -9.82504470494768E-4, -7.81692899252715E-4, -3.66775820220804E-4, 1.83416169919086E-4, 7.63296964727054E-4, 0.00125980163155078, 0.00157365651799556, 0.00163813734628643, 0.00143228621248031, 9.85476250082807E-4, 3.7285572048885E-4, -2.98152986619019E-4, -9.07384243766655E-4, -0.00134444209695172, -0.00152949276953303, -0.00142891708711331, -0.00106227941833982, -4.99669263582827E-4, 1.50755304146288E-4, 7.6234087929536E-4, 0.00121357089114537, 0.00141088442354037, 0.00130687364779612, 9.0986693888556E-4, 2.83438836206569E-4, -4.64720243596698E-4, -0.00120218142834308, -0.00179638061831811, -0.00213943521160232, -0.00216898578250211, -0.00188060329600902, -0.00132975088840251, -6.22282918266146E-4, 1.0447037192244E-4, 7.07100966540956E-4, 0.00106288579277491, 0.0010933599394102, 7.79759007376738E-4, 1.67731567404481E-4, -6.40203673959743E-4, -0.00150281291712562, -0.00226613307010532, -0.00279210409544492, -0.00298494810943401, -0.00280985876267867, -0.00230077814015934, -0.00155516788603045, -7.16946449325894E-4, 4.98425162577E-5, 5.91427811460621E-4, 7.93553359180197E-4, 6.03626371741223E-4, 4.18882442035887E-5, -8.01113927599773E-4, -0.00178012805276415, -0.00272159333227661, -0.00345566817171523, -0.00384837663407466, -0.0038274287920596, -0.00339713383295239, -0.0026389926345583, -0.00169797079597746, -7.56362553657179E-4, -3.02801614322377E-7, 4.15303124638464E-4, 3.96486626536007E-4, -7.07582257228779E-5, -9.16299236533598E-4, -0.00199725651943966, -0.00312350225351387, -0.0040923984060442, -0.00472678969339786, -0.00490881515896487, -0.0046034450441617, -0.00386674837933375, -0.00283736136973274, -0.00171205950763413, -7.10028821381479E-4, -3.19766104447796E-5, 1.78005205844006E-4, -1.39079612299567E-4, -9.4420432887318E-4, -0.00210539663183083, -0.00342058739997302, -0.00465401417839112, -0.00557995156612952, -0.00602539931306045, -0.00590398183887164, -0.00523417542360424, -0.00413837160798384, -0.00282220492576368, -0.00153786268861382, -5.37603813784902E-4, -2.62833612978657E-5, -1.21501341208779E-4, -8.29341117202341E-4, -0.00204036227034438, -0.00354738366789472, -0.00508198134809249, -0.00636358411753227, -0.00715198450674306, -0.00729374687426444, -0.00675336186413425, -0.00562315333865641, -0.00410925127068627, -0.0024958874386246, -0.00109388518637658, -1.82849419019012E-4, 4.25002186405121E-5, -4.88598112186092E-4, -0.00170597869344896, -0.0034077424198901, -0.00529439806145769, -0.00702249784257682, -0.00826802752262929, -0.00878816295614779, -0.00846951380687305, -0.00735360701803667, -0.00563389951885155, -0.00362421333211422, -0.00170340034633871, -2.46078432288275E-4, 4.48220493090697E-4, 2.14038601094618E-4, -9.44144342204741E-4, -0.00284688065681757, -0.00516735944741822, -0.00748779521095554, -0.00937485221013864, -0.010460832484825, -0.0105154409918717, -0.00949451455636883, -0.00755555220454338, -0.00503604893255608, -0.00239708312458895, -1.41510749016328E-4, 0.00127911047620282, 0.00155177140920011, 5.6704834171846E-4, -0.00155130143843582, -0.00445908005673155, -0.00764634029517581, -0.0105255608719074, -0.0125385395087861, -0.013262846112682, -0.0124981540711494, -0.0103153202185525, -0.00705740100760807, -0.00328988355713241, 2.93142491633399E-4, 0.00299195454090684, 0.00423206494064704, 0.00367942048382208, 0.00131776653753629, -0.00252808679982519, -0.00723063563671066, -0.0119562940256244, -0.0158063443723257, -0.0179793574883495, -0.0179272006989418, -0.0154760392566849, -0.0108883680748677, -0.00485085240159456, 0.00161504006609049, 0.00730955626257326, 0.0110558916788708, 0.0119147925193301, 0.00937681513265424, 0.00349822751127974, -0.00504625235976391, -0.0150084099659343, -0.0247086729108038, -0.0322590319016573, -0.0358365930989115, -0.0339679171620155, -0.0257807599622063, -0.0111828622087802, 0.00906290466419837, 0.0333830906953785, 0.0595562582455106, 0.0849741290731021, 0.106966442254914, 0.123144409178258, 0.13171399483958, 0.13171399483958, 0.123144409178258, 0.106966442254914, 0.0849741290731021, 0.0595562582455106, 0.0333830906953785, 0.00906290466419837, -0.0111828622087802, -0.0257807599622063, -0.0339679171620155, -0.0358365930989115, -0.0322590319016573, -0.0247086729108038, -0.0150084099659343, -0.00504625235976391, 0.00349822751127974, 0.00937681513265424, 0.0119147925193301, 0.0110558916788708, 0.00730955626257326, 0.00161504006609049, -0.00485085240159456, -0.0108883680748677, -0.0154760392566849, -0.0179272006989418, -0.0179793574883495, -0.0158063443723257, -0.0119562940256244, -0.00723063563671066, -0.00252808679982519, 0.00131776653753629, 0.00367942048382208, 0.00423206494064704, 0.00299195454090684, 2.93142491633399E-4, -0.00328988355713241, -0.00705740100760807, -0.0103153202185525, -0.0124981540711494, -0.013262846112682, -0.0125385395087861, -0.0105255608719074, -0.00764634029517581, -0.00445908005673155, -0.00155130143843582, 5.6704834171846E-4, 0.00155177140920011, 0.00127911047620282, -1.41510749016328E-4, -0.00239708312458895, -0.00503604893255608, -0.00755555220454338, -0.00949451455636883, -0.0105154409918717, -0.010460832484825, -0.00937485221013864, -0.00748779521095554, -0.00516735944741822, -0.00284688065681757, -9.44144342204741E-4, 2.14038601094618E-4, 4.48220493090697E-4, -2.46078432288275E-4, -0.00170340034633871, -0.00362421333211422, -0.00563389951885155, -0.00735360701803667, -0.00846951380687305, -0.00878816295614779, -0.00826802752262929, -0.00702249784257682, -0.00529439806145769, -0.0034077424198901, -0.00170597869344896, -4.88598112186092E-4, 4.25002186405121E-5, -1.82849419019012E-4, -0.00109388518637658, -0.0024958874386246, -0.00410925127068627, -0.00562315333865641, -0.00675336186413425, -0.00729374687426444, -0.00715198450674306, -0.00636358411753227, -0.00508198134809249, -0.00354738366789472, -0.00204036227034438, -8.29341117202341E-4, -1.21501341208779E-4, -2.62833612978657E-5, -5.37603813784902E-4, -0.00153786268861382, -0.00282220492576368, -0.00413837160798384, -0.00523417542360424, -0.00590398183887164, -0.00602539931306045, -0.00557995156612952, -0.00465401417839112, -0.00342058739997302, -0.00210539663183083, -9.4420432887318E-4, -1.39079612299567E-4, 1.78005205844006E-4, -3.19766104447796E-5, -7.10028821381479E-4, -0.00171205950763413, -0.00283736136973274, -0.00386674837933375, -0.0046034450441617, -0.00490881515896487, -0.00472678969339786, -0.0040923984060442, -0.00312350225351387, -0.00199725651943966, -9.16299236533598E-4, -7.07582257228779E-5, 3.96486626536007E-4, 4.15303124638464E-4, -3.02801614322377E-7, -7.56362553657179E-4, -0.00169797079597746, -0.0026389926345583, -0.00339713383295239, -0.0038274287920596, -0.00384837663407466, -0.00345566817171523, -0.00272159333227661, -0.00178012805276415, -8.01113927599773E-4, 4.18882442035887E-5, 6.03626371741223E-4, 7.93553359180197E-4, 5.91427811460621E-4, 4.98425162577E-5, -7.16946449325894E-4, -0.00155516788603045, -0.00230077814015934, -0.00280985876267867, -0.00298494810943401, -0.00279210409544492, -0.00226613307010532, -0.00150281291712562, -6.40203673959743E-4, 1.67731567404481E-4, 7.79759007376738E-4, 0.0010933599394102, 0.00106288579277491, 7.07100966540956E-4, 1.0447037192244E-4, -6.22282918266146E-4, -0.00132975088840251, -0.00188060329600902, -0.00216898578250211, -0.00213943521160232, -0.00179638061831811, -0.00120218142834308, -4.64720243596698E-4, 2.83438836206569E-4, 9.0986693888556E-4, 0.00130687364779612, 0.00141088442354037, 0.00121357089114537, 7.6234087929536E-4, 1.50755304146288E-4, -4.99669263582827E-4, -0.00106227941833982, -0.00142891708711331, -0.00152949276953303, -0.00134444209695172, -9.07384243766655E-4, -2.98152986619019E-4, 3.7285572048885E-4, 9.85476250082807E-4, 0.00143228621248031, 0.00163813734628643, 0.00157365651799556, 0.00125980163155078, 7.63296964727054E-4, 1.83416169919086E-4, -3.66775820220804E-4, -7.81692899252715E-4, -9.82504470494768E-4, -9.31420112254212E-4, -6.37884782523169E-4, -1.56208575877302E-4, 4.25335294937135E-4, 0.00100124647033075, 0.00146872604881992, 0.00174651275888789, 0.00178971139213456, 0.00159738209371754, 0.0012121573011249, 7.11525817673556E-4, 1.93088506220769E-4, -2.43954622688529E-4, -5.17038609916063E-4, -5.75386700363658E-4, -4.08761057604636E-4, -4.88633815893146E-5, 4.37330250865943E-4, 9.60366107007573E-4, 0.00142535532397548, 0.00174946519687166, 0.00187719780614157, 0.00179008298063751, 0.00150966475862766, 0.00109274642643676, 6.20484195280941E-4, 1.82850004396995E-4, -1.37996600502361E-4, -2.8293202316019E-4, -2.26295960430978E-4, 1.9730705769468E-5, 4.08117020837066E-4, 8.66067932635046E-4, 0.00130904009040423, 0.00165640715611924, 0.00184646637631842, 0.00184740513073318, 0.00166288067239408, 0.00133064261755464, 9.15185152311649E-4, 4.95251264637447E-4, 1.49210026530823E-4, -5.95892868598273E-5, -9.41422652072306E-5, 4.9611695770945E-5, 3.42704502465947E-4, 7.28840658240885E-4, 0.00113538873580102, 0.00148689997345125, 0.00171926753558527, 0.00179124501034788, 0.00169189034302864, 0.00144196301098922, 0.00108976947205013, 7.01646118277693E-4, 3.49587730781208E-4, 9.76836786773469E-5, -9.44217447750788E-6, 4.52472361597781E-5, 2.48641831922795E-4, 5.6019737374658E-4, 9.20018434871427E-4, 0.00126005466552864, 0.00151697631774312, 0.00164363911682995, 0.00161772585583283, 0.00144532357565324, 0.00115954087382408, 8.13805297511983E-4, 4.71854489811893E-4, 1.95625958665316E-4, 3.4012343541018E-5, 1.3849309144843E-5, 1.35466757159849E-4, 3.72855678084063E-4, 6.79052557660961E-4, 9.94960964833502E-4, 0.00126063555002634, 0.00142619655393134, 0.00146107399744823, 0.00135918714255885, 0.00113987720111445, 8.43769833829344E-4, 5.25127275789142E-4, 2.41435399013574E-4, 4.29148478210438E-5, -3.68288426928038E-5, 1.34194308769052E-5, 1.80569079914348E-4, 4.30193817156114E-4, 7.13031741195615E-4, 9.74496584720574E-4, 0.0011646592200388, 0.00124758803351198, 0.00120759179058643, 0.00105200093732304, 8.09281106655558E-4, 5.2364554256276E-4, 2.464637750764E-4, 2.68551602843451E-5, -9.75382510211861E-5, -1.0714149456976E-4, -3.97963442099545E-6, 1.89211708760537E-4, 4.33304948104277E-4, 6.80444821457835E-4, 8.82824811935392E-4, 0.00100170797231571, 0.00101425160569053, 9.17680849208474E-4, 7.2930778548967E-4, 4.83230524813043E-4, 2.23593185867299E-4, -3.51663112894297E-6, -1.58799772313772E-4, -2.16702229081013E-4, -1.70122935327124E-4, -3.12520579316764E-5, 1.70770556774819E-4, 3.95685490536059E-4, 5.99512281288621E-4, 7.42921251348084E-4, 7.982248319367E-4, 7.54513329299535E-4, 6.19220331665681E-4, 4.16678727825662E-4, 1.83180508682799E-4, -3.96953994968743E-5, -2.13033893593434E-4, -3.07522853427615E-4, -3.08920034466907E-4, -2.20256642442962E-4, -6.12246546286886E-5, 1.35904911184024E-4, 3.3221821078459E-4, 4.8963925032985E-4, 5.77738539851612E-4, 5.79439273810329E-4, 4.93770262973607E-4, 3.36015790834792E-4, 1.34455506846221E-4, -7.48344639902692E-5, -2.54954924592149E-4, -3.74794893114052E-4, -4.14892907150544E-4, -3.70652605605774E-4, -2.53184359458119E-4, -8.68245287093865E-5, 9.53324649004418E-5, 2.57871342545317E-4, 3.69410870378961E-4, 4.08543598287131E-4, 3.67434261574489E-4, 2.53285447950829E-4, 8.65917343263471E-5, -1.02610485587946E-4, -2.80623721390072E-4, -4.16139661135309E-4, -4.86191446429637E-4, -4.80063170756953E-4, -4.01313076289361E-4, -2.66713802736679E-4, -1.03198447100559E-4, 5.74523943528654E-5, 1.84316204896415E-4, 2.5323129899956E-4, 2.50946901093621E-4, 1.77638742212356E-4, 4.64904244119377E-5, -1.18683678206045E-4, -2.88174788977175E-4, -4.31708214571715E-4, -5.24244802280253E-4, -5.50312187666917E-4, -5.06955565217396E-4, -4.03915938898268E-4, -2.61904280504075E-4, -1.08442383216512E-4, 2.70624688829392E-5, 1.18971164016274E-4, 1.49870978174831E-4, 1.13908852304928E-4, 1.75247095049829E-5, -1.21647686322812E-4, -2.78364015955548E-4, -4.24271089806838E-4, -5.33373583604141E-4, -5.86569142963063E-4, -5.75313621310307E-4, -5.02871887665066E-4, -3.83829338777272E-4, -2.41089628777638E-4, -1.01816886829692E-4, 7.8132740985481E-6, 6.71888260706398E-5, 6.52221969033149E-5, 2.08912857755044E-6, -1.10666382579362E-4, -2.5255457870159E-4, -3.97735963103583E-4, -5.20018323470526E-4, -5.97431437802573E-4, -6.1644929580642E-4, -5.74195668379932E-4, -4.79138906517235E-4, -3.49264936862277E-4, -2.08973511855545E-4, -8.43683732439765E-5, 1.28683042804457E-6, 3.20306720584621E-5, 1.8664996724834E-6, -8.39458869442319E-5, -2.10096448291764E-4, -3.5379923287896E-4, -4.89172991016836E-4, -5.9171601394605E-4, -6.42981223594934E-4, -6.33691820405254E-4, -5.65653686021656E-4, -4.51218621755097E-4, -3.11303641234571E-4, -1.71410449954226E-4, -5.7277674807016E-5, 9.98070420727893E-6, 1.74584888808446E-5, -3.69617246459944E-5, -1.44403231408916E-4, -2.86293068422389E-4, -4.37843807718034E-4, -5.72186532290299E-4, -6.65360053537445E-4, -7.00350679062249E-4, -6.7039277429577E-4, -5.80032844849327E-4, -4.44674887956967E-4, -2.87767026596535E-4, -1.37026795703571E-4, -1.94228353791984E-5, 4.32881937489408E-5, 3.86308033064396E-5, -3.45312065837977E-5, -1.65400913899566E-4, -3.33137954084399E-4, -5.10005871163562E-4, -6.66185490192942E-4, -7.74523301469025E-4, -8.15365828849824E-4, -7.79750742743636E-4, -6.71317451493218E-4, -5.05715502523139E-4, -3.08509874719252E-4, -1.10987588308181E-4, 5.45352349753129E-5, 1.60107470556599E-4, 1.86466300968715E-4, 1.26516426775505E-4, -1.34624881903889E-5, -2.14182662702644E-4, -4.46146123317908E-4, -6.73493754692806E-4, -8.59260495804291E-4, -9.70341482030938E-4, -9.82353338460868E-4, -8.82833781720179E-4, -6.73193852496632E-4, -3.68302018467704E-4, 5.24895417994034E-6, 4.12844215447331E-4, 8.16034117695199E-4, 0.00117746477759056, 0.00146506438032912, 0.00165575166183813, 0.00173740932884499, 0.00170981291692959, 0.00158354624155544, 0.0013781195000037, 0.00111885157865328, 8.33627498869421E-4, 5.49359171310485E-4, 2.89279202398974E-4, 7.06479844998841E-5, -9.60607754678275E-5, -2.07456105101242E-4, -2.66503975879537E-4, -2.80928519745322E-4, -2.61497617618105E-4, -2.20230946712853E-4, -1.68411968763922E-4, -1.1588027064266E-4, -9.7440442358423E-5};
        private int BUFFER_SIZE_HPF = 948;
        private int filtered;
        private float[] eegBuffer_filtered = new float[this.BUFFER_SIZE_HPF];
        private float[] tempeegBuffer_filtered = new float[this.BUFFER_SIZE_HPF];
        private int bufferCounter = 0;
        private TGBlinkDetector blink;
        private TGSamplingRateCalculator sratecalc;
        private TGHrv hrv;
        private RespiratoryRate respiratory;
        private EnergyLevel energy;
        private Positivity positivity;
        private TaskFamiliarity familiarity;
        private TaskDifficulty difficulty;
        private int poorSignal = 255;
        private int rrint = 0;
        private int samplingRate = 0;
        private long timeLastInterval = -1L;
        private long timeInt;
        private int zone = 0;
        private int attention = 0;
        private /* synthetic */ TGDevice this$0;

        /*
         * WARNING - void declaration
         */
        public TGParser(TGDevice tGDevice, Handler handler, boolean rawDataEnable) {
            void var2_2;
            void var3_3;
            this.this$0 = tGDevice;
            this.handler = handler;
            this.rawEnabled = var3_3;
            this.parserState = 1;
            this.blink = new TGBlinkDetector();
            this.respiratory = new RespiratoryRate((Handler)var2_2);
            this.energy = new EnergyLevel();
            this.sratecalc = new TGSamplingRateCalculator();
            this.hrv = new TGHrv();
            this.positivity = new Positivity();
            this.familiarity = new TaskFamiliarity();
            this.difficulty = new TaskDifficulty();
        }

        /*
         * Unable to fully structure code
         */
        public final int parseByte(byte currByte) {
            switch (this.parserState) {
                case 1: {
                    if ((currByte & 255) == 170) {
                        this.parserState = 2;
                        break;
                    }
                    if (!TGDevice.access$900(this.this$0)) break;
                    TGDevice.access$1000(this.this$0, "Waiting for sync");
                    break;
                }
                case 2: {
                    if ((currByte & 255) == 170) {
                        this.parserState = 3;
                        break;
                    }
                    this.parserState = 1;
                    if (!TGDevice.access$900(this.this$0)) break;
                    TGDevice.access$1000(this.this$0, "Bad 2nd sync byte");
                    break;
                }
                case 3: {
                    this.payloadLength = currByte & 255;
                    if (this.payloadLength < 170) {
                        this.payloadBytesReceived = 0;
                        this.payloadSum = 0;
                        this.parserState = 4;
                        break;
                    }
                    if (this.payloadLength == 170) {
                        this.parserState = 2;
                        break;
                    }
                    this.parserState = 1;
                    break;
                }
                case 4: {
                    this.payload[this.payloadBytesReceived++] = currByte;
                    this.payloadSum += currByte & 255;
                    if (this.payloadBytesReceived != this.payloadLength) break;
                    this.parserState = 5;
                    break;
                }
                case 5: {
                    this.checksum = var1_1 & 255;
                    if (this.checksum != (~this.payloadSum & 255)) ** GOTO lbl296
                    if (this.handler == null) ** GOTO lbl294
                    var1_2 = this;
                    var2_3 = 0;
                    var3_7 = 0;
                    var2_3 = 0;
                    var4_8 = 0;
                    var5_9 = 0;
                    var6_10 = 0;
                    var7_11 = 0;
                    var8_12 = 0;
                    var9_13 = 0;
                    var10_14 = 0;
                    var2_3 = 0;
                    var11_15 = 0;
                    block22: while (var11_15 < var1_2.payloadLength) {
                        var2_3 = var1_2.payload[var11_15] & 255;
                        ++var11_15;
                        if (var2_3 > 127) {
                            var3_7 = var1_2.payload[var11_15] & 255;
                            ++var11_15;
                        } else {
                            var3_7 = 1;
                        }
                        switch (var2_3) {
                            case 1: {
                                var1_2.handler.obtainMessage(20).sendToTarget();
                                continue block22;
                            }
                            case 2: {
                                if (var1_2.rawCountEnabled) {
                                    var1_2.handler.obtainMessage(19, var1_2.rawCount, 0).sendToTarget();
                                    TGDevice.access$1000(var1_2.this$0, "Raw Count: " + var1_2.rawCount);
                                    var1_2.rawCount = 0;
                                }
                                if (var1_2.trimByteSent && var1_2.poorSignal == 200 && (var1_2.payload[var11_15] & 255) == 0) {
                                    var1_2.hrv.Reset();
                                    TGDevice.access$1100(var1_2.this$0).clear();
                                    TGDevice.access$1200(var1_2.this$0).clear();
                                    TGDevice.access$1300(var1_2.this$0).clear();
                                    TGDevice.access$1402(0);
                                    var1_2.calculationEnabled = false;
                                    for (var16_16 = 0; var16_16 < var1_2.BUFFER_SIZE_HPF; ++var16_16) {
                                        var1_2.tempeegBuffer_filtered[var16_16] = 0.0f;
                                        var1_2.eegBuffer_filtered[var16_16] = 0.0f;
                                    }
                                }
                                var1_2.poorSignal = var1_2.payload[var11_15] & 255;
                                var1_2.handler.obtainMessage(2, var1_2.poorSignal, 0).sendToTarget();
                                if (TGDevice.access$900(var1_2.this$0)) {
                                    TGDevice.access$1000(var1_2.this$0, "02 01 " + String.format("%02X", new Object[]{var1_2.payload[var11_15] & 255}) + " PoorSignal: " + var1_2.poorSignal);
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 4: {
                                var1_2.attention = var1_2.payload[var11_15] & 255;
                                var1_2.handler.obtainMessage(4, var1_2.attention, 0).sendToTarget();
                                if (TGDevice.access$900(var1_2.this$0)) {
                                    TGDevice.access$1000(var1_2.this$0, "04 01 " + String.format("%02X", new Object[]{var1_2.payload[var11_15] & 255}) + " Attention: " + (var1_2.payload[var11_15] & 255));
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 5: {
                                var1_2.handler.obtainMessage(5, var1_2.payload[var11_15] & 255, 0).sendToTarget();
                                var1_2.zone = Meditation.getZone((int)var1_2.attention, (byte)var1_2.payload[var11_15]);
                                var1_2.handler.obtainMessage(14, var1_2.zone, 0).sendToTarget();
                                if (TGDevice.access$900(var1_2.this$0)) {
                                    TGDevice.access$1000(var1_2.this$0, "05 01 " + String.format("%02X", new Object[]{var1_2.payload[var11_15] & 255}) + " Meditation: " + (var1_2.payload[var11_15] & 255));
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 3: {
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 128: {
                                var2_3 = (var1_2.payload[var11_15] << 8) + var1_2.payload[var11_15 + 1];
                                if (var2_3 > 32768) {
                                    var2_3 -= 65536;
                                }
                                if (TGDevice.ekgPersonalizationEnabled) {
                                    var1_2.this$0.ekgSenseMan.addSample(var2_3, var1_2.poorSignal);
                                }
                                System.arraycopy(var1_2.eegBuffer_filtered, 1, var1_2.tempeegBuffer_filtered, 0, var1_2.BUFFER_SIZE_HPF - 1);
                                var1_2.tempeegBuffer_filtered[var1_2.BUFFER_SIZE_HPF - 1] = var2_3;
                                System.arraycopy(var1_2.tempeegBuffer_filtered, 0, var1_2.eegBuffer_filtered, 0, var1_2.BUFFER_SIZE_HPF);
                                ++var1_2.bufferCounter;
                                if (var1_2.bufferCounter >= var1_2.BUFFER_SIZE_HPF) {
                                    var1_2.filtered = var1_2.applyFilter(var1_2.eegBuffer_filtered);
                                    var1_2.bufferCounter = var1_2.BUFFER_SIZE_HPF - 1;
                                }
                                if (var1_2.rawEnabled) {
                                    var1_2.handler.obtainMessage(128, var2_3, 0).sendToTarget();
                                    if (TGDevice.access$900(var1_2.this$0)) {
                                        TGDevice.access$1000(var1_2.this$0, "80 02 " + String.format("%02X", new Object[]{var1_2.payload[var11_15] & 255}) + " " + String.format("%02X", new Object[]{var1_2.payload[var11_15 + 1] & 255}) + " Raw: " + var2_3);
                                    }
                                }
                                if (var1_2.rawCountEnabled) {
                                    ++var1_2.rawCount;
                                }
                                var1_2.samplingRate;
                                if (!var1_2.trimByteSent || var1_2.poorSignal != 200) ** GOTO lbl167
                                TGDevice.access$1408();
                                if (TGDevice.access$1400() >= var1_2.this$0.pass_seconds << 9) {
                                    var1_2.calculationEnabled = true;
                                }
                                var1_2.rrint = var1_2.hrv.AddData(var1_2.filtered);
                                if (var1_2.rrint <= 0) ** GOTO lbl167
                                if (!var1_2.timeBasedIntervalEnabled) ** GOTO lbl140
                                if (var1_2.timeLastInterval != -1L) {
                                    var1_2.timeInt = System.currentTimeMillis() - var1_2.timeLastInterval;
                                    var1_2.rrint = var1_2.timeInt > -2147483648L && var1_2.timeInt < 0x7FFFFFFFL ? (int)var1_2.timeInt : (int)Math.round((double)var1_2.rrint / 0.512);
                                    var1_2.timeLastInterval = System.currentTimeMillis();
                                } else {
                                    var1_2.timeLastInterval = System.currentTimeMillis();
lbl140:
                                    // 2 sources

                                    var1_2.rrint = (int)Math.round((double)var1_2.rrint / 0.512);
                                }
                                var1_2.handler.obtainMessage(271, var1_2.rrint, 0).sendToTarget();
                                if (var1_2.calculationEnabled) {
                                    TGDevice.access$1100(var1_2.this$0).add(var1_2.rrint);
                                    TGDevice.access$1200(var1_2.this$0).add(var1_2.rrint);
                                    if (TGDevice.access$1200(var1_2.this$0).size() == 70) {
                                        var16_17 = new Integer[70];
                                        for (var17_24 = 0; var17_24 < 70; ++var17_24) {
                                            var16_17[var17_24] = (Integer)TGDevice.access$1200(var1_2.this$0).get(var17_24);
                                        }
                                        if (var1_2.this$0.inputAge > 0) {
                                            var17_24 = (int)NeuroSkyHeartMeters.calculateHeartAge((Integer[])var16_17, (int)var1_2.this$0.inputAge, (int)16);
                                            var1_2.handler.obtainMessage(272, var17_24, 0).sendToTarget();
                                        }
                                        TGDevice.access$1200(var1_2.this$0).clear();
                                    }
                                    if (TGDevice.access$1100(var1_2.this$0).size() == 300) {
                                        var16_18 = new Integer[180];
                                        for (var17_24 = 120; var17_24 < 300; ++var17_24) {
                                            var16_18[var17_24 - 120] = (Integer)TGDevice.access$1100(var1_2.this$0).get(var17_24);
                                        }
                                        if (var1_2.this$0.inputAge > 0) {
                                            var17_24 = (int)NeuroSkyHeartMeters.calculateHeartAge((Integer[])var16_18, (int)var1_2.this$0.inputAge, (int)8);
                                            var1_2.handler.obtainMessage(273, var17_24, 0).sendToTarget();
                                        }
                                    }
                                }
                                var16_19 = 60.0 / ((double)var1_2.rrint / 1000.0);
                                var16_19 = Math.round(var16_19);
                                var1_2.handler.obtainMessage(3, (int)var16_19, 0).sendToTarget();
lbl167:
                                // 3 sources

                                if (var1_2.trimByteSent && var1_2.rrint > 0 && var1_2.relaxationEnabled && var1_2.calculationEnabled && (var16_20 = var1_2.energy.addInterval(var1_2.rrint, var1_2.poorSignal)) > 0) {
                                    var1_2.handler.obtainMessage(24, var16_20, 0).sendToTarget();
                                }
                                if (var1_2.trimByteSent && var1_2.respirationEnabled) {
                                    var1_2.respiratory.calculateRespiratoryRate((short)var2_3, var1_2.poorSignal);
                                }
                                TGDevice.access$1300(var1_2.this$0).add(var2_3);
                                if (TGDevice.access$1300(var1_2.this$0).size() == 30720) {
                                    var16_21 = new double[30720];
                                    for (var17_24 = 0; var17_24 < 30720; ++var17_24) {
                                        var16_21[var17_24] = ((Integer)TGDevice.access$1300(var1_2.this$0).get(var17_24)).intValue();
                                    }
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 131: {
                                if (var3_7 == 24) {
                                    var2_3 = TGParser.getEEGPowerValue(var1_2.payload[var11_15], var1_2.payload[var11_15 + 1], var1_2.payload[var11_15 + 2]);
                                    var4_8 = TGParser.getEEGPowerValue(var1_2.payload[var11_15 + 3], var1_2.payload[var11_15 + 4], var1_2.payload[var11_15 + 5]);
                                    var5_9 = TGParser.getEEGPowerValue(var1_2.payload[var11_15 + 6], var1_2.payload[var11_15 + 7], var1_2.payload[var11_15 + 8]);
                                    var6_10 = TGParser.getEEGPowerValue(var1_2.payload[var11_15 + 9], var1_2.payload[var11_15 + 10], var1_2.payload[var11_15 + 11]);
                                    var7_11 = TGParser.getEEGPowerValue(var1_2.payload[var11_15 + 12], var1_2.payload[var11_15 + 13], var1_2.payload[var11_15 + 14]);
                                    var8_12 = TGParser.getEEGPowerValue(var1_2.payload[var11_15 + 15], var1_2.payload[var11_15 + 16], var1_2.payload[var11_15 + 17]);
                                    var9_13 = TGParser.getEEGPowerValue(var1_2.payload[var11_15 + 18], var1_2.payload[var11_15 + 19], var1_2.payload[var11_15 + 20]);
                                    var10_14 = TGParser.getEEGPowerValue(var1_2.payload[var11_15 + 21], var1_2.payload[var11_15 + 22], var1_2.payload[var11_15 + 23]);
                                    var16_22 = new TGEegPower(var2_3, var4_8, var5_9, var6_10, var7_11, var8_12, var9_13, var10_14);
                                    var1_2.handler.obtainMessage(131, (Object)var16_22).sendToTarget();
                                    if (TGDevice.access$900(var1_2.this$0)) {
                                        TGDevice.access$1000(var1_2.this$0, "83 18 " + String.format("%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X", new Object[]{var1_2.payload[var11_15], var1_2.payload[var11_15 + 1], var1_2.payload[var11_15 + 2], var1_2.payload[var11_15 + 3], var1_2.payload[var11_15 + 4], var1_2.payload[var11_15 + 5], var1_2.payload[var11_15 + 6], var1_2.payload[var11_15 + 7], var1_2.payload[var11_15 + 8], var1_2.payload[var11_15 + 9], var1_2.payload[var11_15 + 10], var1_2.payload[var11_15 + 11], var1_2.payload[var11_15 + 12], var1_2.payload[var11_15 + 13], var1_2.payload[var11_15 + 14], var1_2.payload[var11_15 + 15], var1_2.payload[var11_15 + 16], var1_2.payload[var11_15 + 17], var1_2.payload[var11_15 + 18], var1_2.payload[var11_15 + 19], var1_2.payload[var11_15 + 20], var1_2.payload[var11_15 + 21], var1_2.payload[var11_15 + 22], var1_2.payload[var11_15 + 23]}));
                                    }
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 144: {
                                var2_4 = new TGRawMulti();
                                new TGRawMulti().ch1 = (var1_2.payload[var11_15] << 8) + var1_2.payload[var11_15 + 1];
                                if (var2_4.ch1 > 32768) {
                                    var2_4.ch1 -= 65536;
                                }
                                if (var3_7 > 3) {
                                    var2_4.ch2 = (var1_2.payload[var11_15 + 3] << 8) + var1_2.payload[var11_15 + 4];
                                    if (var2_4.ch2 > 32768) {
                                        var2_4.ch2 -= 65536;
                                    }
                                    if (var3_7 > 6) {
                                        var2_4.ch3 = (var1_2.payload[var11_15 + 6] << 8) + var1_2.payload[var11_15 + 7];
                                        if (var2_4.ch3 > 32768) {
                                            var2_4.ch3 -= 65536;
                                        }
                                        if (var3_7 > 9) {
                                            var2_4.ch4 = (var1_2.payload[var11_15 + 9] << 8) + var1_2.payload[var11_15 + 10];
                                            if (var2_4.ch4 > 32768) {
                                                var2_4.ch4 -= 65536;
                                            }
                                            if (var3_7 > 12) {
                                                var2_4.ch5 = (var1_2.payload[var11_15 + 12] << 8) + var1_2.payload[var11_15 + 13];
                                                if (var2_4.ch5 > 32768) {
                                                    var2_4.ch5 -= 65536;
                                                }
                                                if (var3_7 > 15) {
                                                    var2_4.ch6 = (var1_2.payload[var11_15 + 15] << 8) + var1_2.payload[var11_15 + 16];
                                                    if (var2_4.ch6 > 32768) {
                                                        var2_4.ch6 -= 65536;
                                                    }
                                                    if (var3_7 > 18) {
                                                        var2_4.ch7 = (var1_2.payload[var11_15 + 18] << 8) + var1_2.payload[var11_15 + 19];
                                                        if (var2_4.ch7 > 32768) {
                                                            var2_4.ch7 -= 65536;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                var1_2.handler.obtainMessage(145, (Object)var2_4).sendToTarget();
                                var16_23 = var1_2.positivity.detect((byte)var1_2.poorSignal, (short)var2_4.ch1, (short)var2_4.ch2);
                                if (var16_23 != 200.0) {
                                    var1_2.handler.obtainMessage(26, (Object)var16_23).sendToTarget();
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 177: {
                                var2_5 = new TGRawMulti();
                                new TGRawMulti().timeStamp1 = (short)var1_2.payload[var11_15] & 255;
                                var2_5.ch1 = (short)((var1_2.payload[var11_15 + 1] << 8) + var1_2.payload[var11_15 + 2]);
                                if (var2_5.ch1 > 32768) {
                                    var2_5.ch1 -= 65536;
                                }
                                var2_5.ch2 = (short)((var1_2.payload[var11_15 + 3] << 8) + var1_2.payload[var11_15 + 4]);
                                if (var2_5.ch2 > 32768) {
                                    var2_5.ch2 -= 65536;
                                }
                                var2_5.ch3 = (var1_2.payload[var11_15 + 5] << 8) + var1_2.payload[var11_15 + 6];
                                if (var2_5.ch3 > 32768) {
                                    var2_5.ch3 -= 65536;
                                }
                                var2_5.ch4 = (var1_2.payload[var11_15 + 7] << 8) + var1_2.payload[var11_15 + 8];
                                if (var2_5.ch4 > 32768) {
                                    var2_5.ch4 -= 65536;
                                }
                                var2_5.ch5 = (var1_2.payload[var11_15 + 9] << 8) + var1_2.payload[var11_15 + 10];
                                if (var2_5.ch5 > 32768) {
                                    var2_5.ch5 -= 65536;
                                }
                                var2_5.ch6 = (var1_2.payload[var11_15 + 11] << 8) + var1_2.payload[var11_15 + 12];
                                if (var2_5.ch6 > 32768) {
                                    var2_5.ch6 -= 65536;
                                }
                                var2_5.ch7 = (var1_2.payload[var11_15 + 13] << 8) + var1_2.payload[var11_15 + 14];
                                if (var2_5.ch7 > 32768) {
                                    var2_5.ch7 -= 65536;
                                }
                                var2_5.ch8 = (var1_2.payload[var11_15 + 15] << 8) + var1_2.payload[var11_15 + 16];
                                if (var2_5.ch8 > 32768) {
                                    var2_5.ch8 -= 65536;
                                }
                                var1_2.handler.obtainMessage(177, (Object)var2_5).sendToTarget();
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 8: {
                                if (!var1_2.trimByteSent && !var1_2.isBMD101) {
                                    var2_6 = new byte[]{-86, -86, 4, 3, 64, -7, 0, var1_2.payload[var11_15]};
                                    TGDevice.access$1500(var1_2.this$0, var2_6);
                                    Log.v((String)"TGDevice", (String)("Sent trim byte: " + var1_2.payload[var11_15]));
                                    var1_2.trimByteSent = true;
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 132: 
                            case 176: {
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 133: {
                                if ((var1_2.payload[var11_15 + 2] & 240) == 240) {
                                    var1_2.isBMD101 = false;
                                } else if (!var1_2.trimByteSent) {
                                    var1_2.trimByteSent = true;
                                }
                                var11_15 += var3_7;
                                continue block22;
                            }
                            case 179: {
                                var2_3 = var1_2.payload[var11_15] & 255;
                                var4_8 = var1_2.payload[var11_15 + 1] & 255;
                                Log.v((String)"TGDevice", (String)("Poorsignal1: " + var2_3 + " ps2: " + var4_8));
                                var1_2.handler.obtainMessage(179, var2_3, var4_8).sendToTarget();
                                var1_2.poorSignal = var2_3 == 200 && var4_8 == 200 ? 200 : 0;
                                var11_15 += var3_7;
                                continue block22;
                            }
                        }
                        Log.v((String)"TGParser", (String)("Unknown code: " + var2_3));
                    }
lbl294:
                    // 2 sources

                    this.parserState = 1;
                    return 1;
lbl296:
                    // 1 sources

                    if (this.checksum == 170) {
                        this.parserState = 2;
                        return -2;
                    }
                    Log.d((String)"TGDevice", (String)("Checksum failed. Recieved: " + this.checksum + ". Calculated: " + (~this.payloadSum & 255)));
                    if (TGDevice.access$900(this.this$0)) {
                        TGDevice.access$1000(this.this$0, "Checksum failed. Received: " + this.checksum + ". Calculated: " + (~this.payloadSum & 255));
                    }
                    this.parserState = 1;
                    return -2;
                }
            }
            return this.parserState;
        }

        /*
         * WARNING - void declaration
         */
        private int applyFilter(float[] data) {
            void var3_3;
            int length = data.length;
            int result = 0;
            for (int i = 0; i < length; ++i) {
                result += (int)((double)data[i] * this.coeff[i]);
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private static int getEEGPowerValue(byte highOrderByte, byte middleOrderByte, byte lowOrderByte) {
            void var2_2;
            void var1_1;
            return (highOrderByte << 16) + (var1_1 << 8) + var2_2 & 0xFFFFFF;
        }
    }

    private final class StreamThread
    extends Thread {
        private TGParser parser;
        private InputStream input;
        private BufferedInputStream buff;
        private int r = -1;
        private int availableBytes = 0;
        private /* synthetic */ TGDevice this$0;

        /*
         * WARNING - void declaration
         */
        public StreamThread(TGDevice tGDevice, InputStream i) {
            void var2_2;
            this.this$0 = tGDevice;
            this.parser = new TGParser(tGDevice, tGDevice.handler, true);
            this.input = var2_2;
            this.buff = new BufferedInputStream(this.input);
        }

        public final void run() {
            if (this.input == null) {
                Log.v((String)"TGDevice", (String)"UART ERROR");
            }
            try {
                do {
                    if (this.this$0.getStart()) {
                        this.availableBytes = this.buff.available();
                        while (this.availableBytes > 0) {
                            this.r = this.buff.read();
                            if (this.r >= 0) {
                                this.parser.parseByte((byte)this.r);
                            }
                            --this.availableBytes;
                        }
                        this.r = -1;
                    }
                    try {
                        Thread.sleep(1L, 500000);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedException interruptedException2 = interruptedException;
                        interruptedException.printStackTrace();
                    }
                } while (this.this$0.getReadable());
                this.input.close();
                return;
            }
            catch (IOException iOException) {
                TGDevice.access$100(this.this$0, 5);
                return;
            }
        }

        public final void cancel() {
            this.this$0.setReadable(false);
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            Log.v((String)"TGDevice", (String)"StreamThread ending");
        }
    }

    private final class ConnectedThread
    extends Thread {
        private BluetoothSocket btSocket;
        private InputStream inStream;
        private TGParser parser;
        private /* synthetic */ TGDevice this$0;

        /*
         * WARNING - void declaration
         */
        public ConnectedThread(TGDevice tGDevice, BluetoothSocket s, boolean rawEnabled) {
            void var3_3;
            void var2_2;
            this.this$0 = tGDevice;
            this.btSocket = var2_2;
            this.parser = new TGParser(tGDevice, tGDevice.handler, (boolean)var3_3);
        }

        /*
         * Loose catch block
         */
        public final void run() {
            Log.v((String)"TGDevice", (String)"Begin ConnectedThread");
            this.setName("ConnectedThread");
            this.inStream = this.btSocket.getInputStream();
            TGDevice.access$502(this.this$0, this.btSocket.getOutputStream());
            byte[] buffer = new byte[1];
            do {
                if (!this.this$0.getStart()) continue;
                this.inStream.read(buffer);
                this.parser.parseByte(buffer[0]);
            } while (this.this$0.getReadable());
            this.inStream.close();
            this.this$0.output.close();
            try {
                this.btSocket.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (IOException iOException) {
                try {
                    TGDevice.access$100(this.this$0, 3);
                }
                catch (Throwable throwable) {
                    try {
                        this.btSocket.close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    this.btSocket.close();
                    return;
                }
                catch (IOException iOException3) {
                    return;
                }
            }
        }

        public final void cancel() {
            try {
                Log.v((String)"TGDevice", (String)"ConnectedThreadEnding");
                this.inStream.close();
                this.this$0.output.close();
                this.btSocket.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            this.this$0.setReadable(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectThread
    extends Thread {
        private int SCAN_TIMEOUT = 5000;
        private Set<BluetoothDevice> btDevices;
        private BluetoothSocket btSocket;
        private TGParser parser;
        private InputStream inStream;
        private int apiVersion;
        private /* synthetic */ TGDevice this$0;

        /*
         * WARNING - void declaration
         */
        public ConnectThread(TGDevice tGDevice, Set<BluetoothDevice> devices) {
            void var2_2;
            this.this$0 = tGDevice;
            this.btDevices = var2_2;
            this.apiVersion = Integer.valueOf(Build.VERSION.SDK);
            this.parser = new TGParser(tGDevice, null, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            Looper.prepare();
            Log.v((String)"TGDevice", (String)"Begin ConnectThread");
            this.setName("ConnectThread");
            if (this.this$0.btAdapter.isDiscovering()) {
                this.this$0.btAdapter.cancelDiscovery();
            }
            if (this.btDevices.size() == 0) {
                TGDevice.access$100(this.this$0, 5);
                return;
            }
            for (BluetoothDevice d : this.btDevices) {
                void var2_2;
                void var3_4;
                block16: {
                    Log.d((String)"TGDevice", (String)("Trying to connect to: " + d.getName()));
                    try {
                        if (this.apiVersion >= 5 && this.apiVersion < 10) {
                            this.btSocket = d.createRfcommSocketToServiceRecord(uuid);
                            break block16;
                        }
                        if (this.apiVersion < 10) break block16;
                        this.btSocket = d.createInsecureRfcommSocketToServiceRecord(uuid);
                    }
                    catch (IOException e) {
                        Log.d((String)"TGDevice", (String)("Error creating socket: " + e));
                        continue;
                    }
                }
                try {
                    this.btSocket.connect();
                }
                catch (IOException iOException) {
                    Log.d((String)"TGDevice", (String)("Could not establish a connection with: " + d.getName()));
                    try {
                        this.btSocket.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
                try {
                    this.inStream = this.btSocket.getInputStream();
                }
                catch (IOException iOException) {
                    Log.d((String)"TGDevice", (String)"Could not get input stream");
                }
                int pState = 0;
                byte[] buffer = new byte[1];
                long start = System.currentTimeMillis();
                do {
                    try {
                        this.inStream.read(buffer);
                        pState = this.parser.parseByte(buffer[0]);
                    }
                    catch (IOException iOException) {}
                } while (pState < 5 && System.currentTimeMillis() - start < (long)this.SCAN_TIMEOUT);
                if (var3_4 == 5) {
                    TGDevice.access$302(this.this$0, d);
                    TGDevice.access$400(this.this$0, this.btSocket);
                    return;
                }
                Log.d((String)"TGDevice", (String)(var2_2.getName() + " is not a valid device."));
            }
            TGDevice.access$100(this.this$0, 4);
            Looper.loop();
        }

        public final void cancel() {
            try {
                if (this.btSocket != null) {
                    this.btSocket.close();
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

