/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class MathHelper {
    public static final double NULL_VALUE = Double.MAX_VALUE;
    private static final NumberFormat FORMAT = NumberFormat.getNumberInstance();

    private MathHelper() {
    }

    public static double[] minmax(List<Double> list) {
        double d;
        if (list.size() == 0) {
            return new double[2];
        }
        double d2 = d = list.get(0).doubleValue();
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            double d3 = list.get(i);
            d = Math.min(d, d3);
            d2 = Math.max(d2, d3);
        }
        return new double[]{d, d2};
    }

    public static List<Double> getLabels(double d, double d2, int n) {
        FORMAT.setMaximumFractionDigits(5);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = MathHelper.computeLabels(d, d2, n);
        int n2 = 1 + (int)((dArray[1] - dArray[0]) / dArray[2]);
        for (int i = 0; i < n2; ++i) {
            double d3 = dArray[0] + (double)i * dArray[2];
            try {
                d3 = FORMAT.parse(FORMAT.format(d3)).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            arrayList.add(d3);
        }
        return arrayList;
    }

    private static double[] computeLabels(double d, double d2, int n) {
        double d3;
        if (Math.abs(d - d2) < (double)1.0E-7f) {
            return new double[]{d, d, 0.0};
        }
        double d4 = d;
        double d5 = d2;
        boolean bl = false;
        if (d4 > d5) {
            bl = true;
            d3 = d4;
            d4 = d5;
            d5 = d3;
        }
        d3 = MathHelper.roundUp(Math.abs(d4 - d5) / (double)n);
        double d6 = d3 * Math.ceil(d4 / d3);
        double d7 = d3 * Math.floor(d5 / d3);
        if (bl) {
            return new double[]{d7, d6, -1.0 * d3};
        }
        return new double[]{d6, d7, d3};
    }

    private static double roundUp(double d) {
        int n = (int)Math.floor(Math.log10(d));
        double d2 = d * Math.pow(10.0, -n);
        if (d2 > 5.0) {
            d2 = 10.0;
        } else if (d2 > 2.0) {
            d2 = 5.0;
        } else if (d2 > 1.0) {
            d2 = 2.0;
        }
        return d2 *= Math.pow(10.0, n);
    }

    public static float[] getFloats(List<Float> list) {
        int n = list.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = list.get(i).floatValue();
        }
        return fArray;
    }
}

