/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.tools.AbstractTool;

public class FitZoom
extends AbstractTool {
    public FitZoom(AbstractChart abstractChart) {
        super(abstractChart);
    }

    public void apply() {
        if (this.mChart instanceof XYChart) {
            if (((XYChart)this.mChart).getDataset() == null) {
                return;
            }
            int n = this.mRenderer.getScalesCount();
            if (this.mRenderer.isInitialRangeSet()) {
                for (int i = 0; i < n; ++i) {
                    if (!this.mRenderer.isInitialRangeSet(i)) continue;
                    this.mRenderer.setRange(this.mRenderer.getInitialRange(i), i);
                }
            } else {
                XYSeries[] xYSeriesArray = ((XYChart)this.mChart).getDataset().getSeries();
                double[] dArray = null;
                int n2 = xYSeriesArray.length;
                if (n2 > 0) {
                    for (int i = 0; i < n; ++i) {
                        dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
                        for (int j = 0; j < n2; ++j) {
                            if (i != xYSeriesArray[j].getScaleNumber()) continue;
                            dArray[0] = Math.min(dArray[0], xYSeriesArray[j].getMinX());
                            dArray[1] = Math.max(dArray[1], xYSeriesArray[j].getMaxX());
                            dArray[2] = Math.min(dArray[2], xYSeriesArray[j].getMinY());
                            dArray[3] = Math.max(dArray[3], xYSeriesArray[j].getMaxY());
                        }
                        double d = Math.abs(dArray[1] - dArray[0]) / 40.0;
                        double d2 = Math.abs(dArray[3] - dArray[2]) / 40.0;
                        this.mRenderer.setRange(new double[]{dArray[0] - d, dArray[1] + d, dArray[2] - d2, dArray[3] + d2}, i);
                    }
                }
            }
        } else {
            DefaultRenderer defaultRenderer = ((RoundChart)this.mChart).getRenderer();
            defaultRenderer.setScale(defaultRenderer.getOriginalScale());
        }
    }
}

