/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public abstract class AbstractTool {
    protected AbstractChart mChart;
    protected XYMultipleSeriesRenderer mRenderer;

    public AbstractTool(AbstractChart abstractChart) {
        this.mChart = abstractChart;
        if (abstractChart instanceof XYChart) {
            this.mRenderer = ((XYChart)abstractChart).getRenderer();
        }
    }

    public double[] getRange(int n) {
        double d = this.mRenderer.getXAxisMin(n);
        double d2 = this.mRenderer.getXAxisMax(n);
        double d3 = this.mRenderer.getYAxisMin(n);
        double d4 = this.mRenderer.getYAxisMax(n);
        return new double[]{d, d2, d3, d4};
    }

    public void checkRange(double[] dArray, int n) {
        double[] dArray2;
        if (this.mChart instanceof XYChart && (dArray2 = ((XYChart)this.mChart).getCalcRange(n)) != null) {
            if (!this.mRenderer.isMinXSet(n)) {
                dArray[0] = dArray2[0];
                this.mRenderer.setXAxisMin(dArray[0], n);
            }
            if (!this.mRenderer.isMaxXSet(n)) {
                dArray[1] = dArray2[1];
                this.mRenderer.setXAxisMax(dArray[1], n);
            }
            if (!this.mRenderer.isMinYSet(n)) {
                dArray[2] = dArray2[2];
                this.mRenderer.setYAxisMin(dArray[2], n);
            }
            if (!this.mRenderer.isMaxYSet(n)) {
                dArray[3] = dArray2[3];
                this.mRenderer.setYAxisMax(dArray[3], n);
            }
        }
    }

    protected void setXRange(double d, double d2, int n) {
        this.mRenderer.setXAxisMin(d, n);
        this.mRenderer.setXAxisMax(d2, n);
    }

    protected void setYRange(double d, double d2, int n) {
        this.mRenderer.setYAxisMin(d, n);
        this.mRenderer.setYAxisMax(d2, n);
    }
}

