/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.ArrayList;
import org.achartengine.chart.RoundChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.renderer.DefaultRenderer;

public class PieChart
extends RoundChart {
    public PieChart(CategorySeries categorySeries, DefaultRenderer defaultRenderer) {
        super(categorySeries, defaultRenderer);
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        int n5;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int n6 = this.getLegendSize(this.mRenderer, n4 / 5, 0.0f);
        int n7 = n;
        int n8 = n2;
        int n9 = n + n3;
        int n10 = this.mDataset.getItemCount();
        double d = 0.0;
        String[] stringArray = new String[n10];
        for (n5 = 0; n5 < n10; ++n5) {
            d += this.mDataset.getValue(n5);
            stringArray[n5] = this.mDataset.getCategory(n5);
        }
        if (this.mRenderer.isFitLegend()) {
            n6 = this.drawLegend(canvas, this.mRenderer, stringArray, n7, n9, n2, n3, n4, n6, paint, true);
        }
        n5 = n2 + n4 - n6;
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint, false, 0);
        float f = 0.0f;
        int n11 = Math.min(Math.abs(n9 - n7), Math.abs(n5 - n8));
        int n12 = (int)((double)n11 * 0.35 * (double)this.mRenderer.getScale());
        if (this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (n7 + n9) / 2;
        }
        if (this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (n5 + n8) / 2;
        }
        float f2 = (float)n12 * 0.9f;
        float f3 = (float)n12 * 1.1f;
        RectF rectF = new RectF((float)(this.mCenterX - n12), (float)(this.mCenterY - n12), (float)(this.mCenterX + n12), (float)(this.mCenterY + n12));
        ArrayList<RectF> arrayList = new ArrayList<RectF>();
        for (int i = 0; i < n10; ++i) {
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            float f4 = (float)this.mDataset.getValue(i);
            float f5 = (float)((double)f4 / d * 360.0);
            canvas.drawArc(rectF, f, f5, true, paint);
            this.drawLabel(canvas, this.mDataset.getCategory(i), this.mRenderer, arrayList, this.mCenterX, this.mCenterY, f2, f3, f, f5, n7, n9, paint);
            f += f5;
        }
        arrayList.clear();
        this.drawLegend(canvas, this.mRenderer, stringArray, n7, n9, n2, n3, n4, n6, paint, false);
        this.drawTitle(canvas, n, n2, n3, paint);
    }
}

