/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import org.achartengine.chart.LineChart;
import org.achartengine.model.Point;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class CubicLineChart
extends LineChart {
    public static final String TYPE = "Cubic";
    private float firstMultiplier;
    private float secondMultiplier;
    private Point p1 = new Point();
    private Point p2 = new Point();
    private Point p3 = new Point();

    public CubicLineChart() {
        this.firstMultiplier = 0.33f;
        this.secondMultiplier = 1.0f - this.firstMultiplier;
    }

    public CubicLineChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, float f) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.firstMultiplier = f;
        this.secondMultiplier = 1.0f - this.firstMultiplier;
    }

    @Override
    protected void drawPath(Canvas canvas, float[] fArray, Paint paint, boolean bl) {
        Path path = new Path();
        float f = fArray[0];
        float f2 = fArray[1];
        path.moveTo(f, f2);
        for (int i = 0; i < fArray.length; i += 2) {
            int n = i + 2 < fArray.length ? i + 2 : i;
            int n2 = i + 4 < fArray.length ? i + 4 : n;
            this.calc(fArray, this.p1, i, n, this.secondMultiplier);
            this.p2.setX(fArray[n]);
            this.p2.setY(fArray[n + 1]);
            this.calc(fArray, this.p3, n, n2, this.firstMultiplier);
            path.cubicTo(this.p1.getX(), this.p1.getY(), this.p2.getX(), this.p2.getY(), this.p3.getX(), this.p3.getY());
        }
        canvas.drawPath(path, paint);
    }

    private void calc(float[] fArray, Point point, int n, int n2, float f) {
        float f2 = fArray[n];
        float f3 = fArray[n + 1];
        float f4 = fArray[n2];
        float f5 = fArray[n2 + 1];
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        point.setX(f2 + f6 * f);
        point.setY(f3 + f7 * f);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

