/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.List;
import org.achartengine.chart.BarChart;
import org.achartengine.chart.BubbleChart;
import org.achartengine.chart.LineChart;
import org.achartengine.chart.RangeBarChart;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.TimeChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class CombinedXYChart
extends XYChart {
    private XYChart[] mCharts;
    private Class[] xyChartTypes = new Class[]{TimeChart.class, LineChart.class, BarChart.class, BubbleChart.class, LineChart.class, ScatterChart.class, RangeBarChart.class};

    public CombinedXYChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String[] stringArray) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        int n = stringArray.length;
        this.mCharts = new XYChart[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.mCharts[i] = this.getXYChart(stringArray[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.mCharts[i] == null) {
                throw new IllegalArgumentException("Unknown chart type " + stringArray[i]);
            }
            XYMultipleSeriesDataset xYMultipleSeriesDataset2 = new XYMultipleSeriesDataset();
            xYMultipleSeriesDataset2.addSeries(xYMultipleSeriesDataset.getSeriesAt(i));
            XYMultipleSeriesRenderer xYMultipleSeriesRenderer2 = new XYMultipleSeriesRenderer();
            xYMultipleSeriesRenderer2.setBarSpacing(xYMultipleSeriesRenderer.getBarSpacing());
            xYMultipleSeriesRenderer2.setPointSize(xYMultipleSeriesRenderer.getPointSize());
            int n2 = xYMultipleSeriesDataset.getSeriesAt(i).getScaleNumber();
            if (xYMultipleSeriesRenderer.isMinXSet(n2)) {
                xYMultipleSeriesRenderer2.setXAxisMin(xYMultipleSeriesRenderer.getXAxisMin(n2));
            }
            if (xYMultipleSeriesRenderer.isMaxXSet(n2)) {
                xYMultipleSeriesRenderer2.setXAxisMax(xYMultipleSeriesRenderer.getXAxisMax(n2));
            }
            if (xYMultipleSeriesRenderer.isMinYSet(n2)) {
                xYMultipleSeriesRenderer2.setYAxisMin(xYMultipleSeriesRenderer.getYAxisMin(n2));
            }
            if (xYMultipleSeriesRenderer.isMaxYSet(n2)) {
                xYMultipleSeriesRenderer2.setYAxisMax(xYMultipleSeriesRenderer.getYAxisMax(n2));
            }
            xYMultipleSeriesRenderer2.addSeriesRenderer(xYMultipleSeriesRenderer.getSeriesRendererAt(i));
            this.mCharts[i].setDatasetRenderer(xYMultipleSeriesDataset2, xYMultipleSeriesRenderer2);
        }
    }

    private XYChart getXYChart(String string) throws IllegalAccessException, InstantiationException {
        XYChart xYChart = null;
        int n = this.xyChartTypes.length;
        for (int i = 0; i < n && xYChart == null; ++i) {
            XYChart xYChart2 = (XYChart)this.xyChartTypes[i].newInstance();
            if (!string.equals(xYChart2.getChartType())) continue;
            xYChart = xYChart2;
        }
        return xYChart;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        this.mCharts[n].setScreenR(this.getScreenR());
        this.mCharts[n].setCalcRange(this.getCalcRange(this.mDataset.getSeriesAt(n).getScaleNumber()), 0);
        this.mCharts[n].drawSeries(canvas, paint, fArray, simpleSeriesRenderer, f, 0);
    }

    @Override
    protected RectF[] clickableAreasForPoints(float[] fArray, float f, int n) {
        return this.mCharts[n].clickableAreasForPoints(fArray, f, 0);
    }

    @Override
    protected void drawSeries(XYSeries xYSeries, Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, XYMultipleSeriesRenderer.Orientation orientation) {
        this.mCharts[n].setScreenR(this.getScreenR());
        this.mCharts[n].setCalcRange(this.getCalcRange(this.mDataset.getSeriesAt(n).getScaleNumber()), 0);
        this.mCharts[n].drawSeries(xYSeries, canvas, paint, list, simpleSeriesRenderer, f, 0, orientation);
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return this.mCharts[n].getLegendShapeWidth(0);
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        this.mCharts[n].drawLegendShape(canvas, simpleSeriesRenderer, f, f2, 0, paint);
    }

    @Override
    public String getChartType() {
        return "Combined";
    }
}

