/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.GradientDrawable;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class BarChart
extends XYChart {
    public static final String TYPE = "Bar";
    private static final int SHAPE_WIDTH = 12;
    protected Type mType = Type.DEFAULT;

    BarChart() {
    }

    public BarChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, Type type) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.mType = type;
    }

    @Override
    protected RectF[] clickableAreasForPoints(float[] fArray, float f, int n) {
        int n2 = this.mDataset.getSeriesCount();
        int n3 = fArray.length;
        RectF[] rectFArray = new RectF[n3 / 2];
        float f2 = this.getHalfDiffX(fArray, n3, n2);
        for (int i = 0; i < n3; i += 2) {
            float f3 = fArray[i];
            float f4 = fArray[i + 1];
            if (this.mType == Type.STACKED) {
                rectFArray[i / 2] = new RectF(f3 - f2, f4, f3 + f2, f);
                continue;
            }
            float f5 = f3 - (float)n2 * f2 + (float)(n * 2) * f2;
            rectFArray[i / 2] = new RectF(f5, f4, f5 + 2.0f * f2, f);
        }
        return rectFArray;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        int n2 = this.mDataset.getSeriesCount();
        int n3 = fArray.length;
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float f2 = this.getHalfDiffX(fArray, n3, n2);
        for (int i = 0; i < n3; i += 2) {
            float f3 = fArray[i];
            float f4 = fArray[i + 1];
            this.drawBar(canvas, f3, f, f3, f4, f2, n2, n, paint);
        }
        paint.setColor(simpleSeriesRenderer.getColor());
    }

    protected void drawBar(Canvas canvas, float f, float f2, float f3, float f4, float f5, int n, int n2, Paint paint) {
        int n3 = this.mDataset.getSeriesAt(n2).getScaleNumber();
        if (this.mType == Type.STACKED) {
            this.drawBar(canvas, f - f5, f4, f3 + f5, f2, n3, n2, paint);
        } else {
            float f6 = f - (float)n * f5 + (float)(n2 * 2) * f5;
            this.drawBar(canvas, f6, f4, f6 + 2.0f * f5, f2, n3, n2, paint);
        }
    }

    private void drawBar(Canvas canvas, float f, float f2, float f3, float f4, int n, int n2, Paint paint) {
        SimpleSeriesRenderer simpleSeriesRenderer = this.mRenderer.getSeriesRendererAt(n2);
        if (simpleSeriesRenderer.isGradientEnabled()) {
            int n3;
            float f5 = (float)this.toScreenPoint(new double[]{0.0, simpleSeriesRenderer.getGradientStopValue()}, n)[1];
            float f6 = (float)this.toScreenPoint(new double[]{0.0, simpleSeriesRenderer.getGradientStartValue()}, n)[1];
            float f7 = Math.max(f5, f2);
            float f8 = Math.min(f6, f4);
            int n4 = simpleSeriesRenderer.getGradientStopColor();
            int n5 = n3 = simpleSeriesRenderer.getGradientStartColor();
            int n6 = n4;
            if (f2 < f5) {
                paint.setColor(n4);
                canvas.drawRect((float)Math.round(f), (float)Math.round(f2), (float)Math.round(f3), (float)Math.round(f7), paint);
            } else {
                n6 = this.getGradientPartialColor(n4, n3, (f6 - f7) / (f6 - f5));
            }
            if (f4 > f6) {
                paint.setColor(n3);
                canvas.drawRect((float)Math.round(f), (float)Math.round(f8), (float)Math.round(f3), (float)Math.round(f4), paint);
            } else {
                n5 = this.getGradientPartialColor(n3, n4, (f8 - f5) / (f6 - f5));
            }
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{n5, n6});
            gradientDrawable.setBounds(Math.round(f), Math.round(f7), Math.round(f3), Math.round(f8));
            gradientDrawable.draw(canvas);
        } else {
            canvas.drawRect((float)Math.round(f), (float)Math.round(f2), (float)Math.round(f3), (float)Math.round(f4), paint);
        }
    }

    private int getGradientPartialColor(int n, int n2, float f) {
        int n3 = Math.round(f * (float)Color.alpha((int)n) + (1.0f - f) * (float)Color.alpha((int)n2));
        int n4 = Math.round(f * (float)Color.red((int)n) + (1.0f - f) * (float)Color.red((int)n2));
        int n5 = Math.round(f * (float)Color.green((int)n) + (1.0f - f) * (float)Color.green((int)n2));
        int n6 = Math.round(f * (float)Color.blue((int)n) + (1.0f - f) * (float)Color.blue((int)n2));
        return Color.argb((int)n3, (int)n4, (int)n5, (int)n6);
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, float[] fArray, int n) {
        int n2 = this.mDataset.getSeriesCount();
        float f = this.getHalfDiffX(fArray, fArray.length, n2);
        for (int i = 0; i < fArray.length; i += 2) {
            int n3 = i / 2;
            if (xYSeries.getY(n3) == Double.MAX_VALUE) continue;
            float f2 = fArray[i];
            if (this.mType == Type.DEFAULT) {
                f2 += (float)(n * 2) * f - ((float)n2 - 1.5f) * f;
            }
            this.drawText(canvas, this.getLabel(xYSeries.getY(n3)), f2, fArray[i + 1] - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
        }
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 12;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        float f3 = 6.0f;
        canvas.drawRect(f, f2 - f3, f + 12.0f, f2 + f3, paint);
    }

    protected float getHalfDiffX(float[] fArray, int n, int n2) {
        float f;
        int n3 = n;
        if (n > 2) {
            n3 = n - 2;
        }
        if ((f = (fArray[n - 2] - fArray[0]) / (float)n3) == 0.0f) {
            f = 10.0f;
        }
        if (this.mType != Type.STACKED) {
            f /= (float)n2;
        }
        return (float)((double)f / ((double)this.getCoeficient() * (1.0 + this.mRenderer.getBarSpacing())));
    }

    protected float getCoeficient() {
        return 1.0f;
    }

    @Override
    protected boolean isRenderNullValues() {
        return true;
    }

    @Override
    public double getDefaultMinimum() {
        return 0.0;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    public static enum Type {
        DEFAULT,
        STACKED;

    }
}

