/*
 * Decompiled with CFR 0.152.
 */
package com.neurosky.thinkgear;

import android.util.Log;
import com.neurosky.thinkgear.DistanceArray;
import com.neurosky.thinkgear.EkgEpoch;
import com.neurosky.thinkgear.EkgParameters;
import com.neurosky.thinkgear.EkgTemplate;
import com.neurosky.thinkgear.TGDevice;

public class EkgSense {
    private final boolean a = TGDevice.ekgPersonalizationEnabled;
    public EkgParameters params;
    public EkgTemplate[] templates;
    public EkgTemplate currentData;
    public int lastTemplateInd = 0;
    public float lastEpochValue = 0.0f;

    public EkgSense(EkgParameters ekgParameters) {
        this.params = ekgParameters;
        this.templates = new EkgTemplate[40];
        this.currentData = new EkgTemplate();
    }

    public void reset() {
        this.templates = new EkgTemplate[40];
        this.currentData = new EkgTemplate();
        this.lastTemplateInd = 0;
    }

    public void addTemplate(String string2, float[][] fArray) {
        this.templates[this.lastTemplateInd] = new EkgTemplate(string2, fArray);
        ++this.lastTemplateInd;
    }

    public void addTemplate(EkgTemplate ekgTemplate) {
        this.templates[this.lastTemplateInd] = ekgTemplate;
        Log.v((String)"EkgSense", (String)("Loaded template: " + ekgTemplate.subjectName + " at index: " + this.lastTemplateInd));
        ++this.lastTemplateInd;
    }

    public String getClassificationResults() {
        if (!this.a) {
            return "Unknown";
        }
        int n = 0;
        float f = 1000000.0f;
        for (int i = 0; i < this.lastTemplateInd; ++i) {
            if (!(this.templates[i].score < f)) continue;
            n = i;
            f = this.templates[i].score;
        }
        float f2 = 1000000.0f;
        for (int i = 0; i < this.lastTemplateInd; ++i) {
            if (!(this.templates[i].score < f2 & this.templates[i].score != f)) continue;
            f2 = this.templates[i].score;
        }
        if (f < (float)this.params.templateMaxDistance) {
            return this.templates[n].subjectName;
        }
        return "Unknown";
    }

    public boolean processData(float[] object) {
        float f;
        System.nanoTime();
        if (!this.a) {
            return false;
        }
        int n = this.params.epochLen / 4;
        EkgEpoch ekgEpoch = new EkgEpoch((float[])object);
        object = ekgEpoch;
        EkgEpoch ekgEpoch2 = ekgEpoch.subEpoch(n, this.params.epochLen - n);
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = this.params.prePeakLatency;
        nArray2[1] = this.params.postPeakLatency;
        int n2 = ekgEpoch2.find_heart_beats(nArray2, this.params.prePeakAmplitude);
        if (n2 != -1 && (f = ekgEpoch2.data[n2]) != this.lastEpochValue) {
            this.lastEpochValue = f;
            if (((EkgEpoch)(object = ((EkgEpoch)object).subEpoch(n2, n2 + 2 * n))).detectHighTail(n2)) {
                object = null;
            }
            if (object == null) {
                if (this.params.verboseMatlab == 1) {
                    System.out.println("Epoch removed");
                }
            } else if (this.params.verboseMatlab == 1) {
                System.out.println("Epoch selected");
            }
            if (object != null && ((EkgEpoch)object).getLineNoiseAmplitude() < (float)this.params.lineNoiseThreshold) {
                EkgEpoch ekgEpoch3;
                object = ((EkgEpoch)object).smooth(this.params.smoothing);
                object = ((EkgEpoch)object).detrend();
                object = ((EkgEpoch)object).subtract(((EkgEpoch)object).median());
                if (ekgEpoch3.std() < (float)this.params.artifactStdThreshold) {
                    if (this.params.stanley == 1) {
                        object = ((EkgEpoch)object).subEpoch2(57, 67, 81, 97);
                        object = ((EkgEpoch)object).subtract(((EkgEpoch)object).median());
                    }
                    this.currentData.addData((EkgEpoch)object);
                    if (this.currentData.lastTemplateIndex > this.params.templateNum) {
                        object = this.currentData.computeDistance(this.currentData);
                        Object object2 = new float[((DistanceArray)object).numRows];
                        int[][] nArray3 = new int[((DistanceArray)object).numRows][this.params.templatesForDist];
                        for (n2 = 0; n2 < ((DistanceArray)object).numRows; ++n2) {
                            Object object3 = new EkgEpoch(((DistanceArray)object).array[n2]);
                            EkgEpoch ekgEpoch4 = ((EkgEpoch)object3).sort();
                            object3 = ((EkgEpoch)object3).sortIndices(ekgEpoch4);
                            object2[n2] = ekgEpoch4.subEpoch(0, this.params.templatesForDist).sum();
                            for (int i = 0; i < this.params.templatesForDist; ++i) {
                                nArray3[n2][i] = (int)object3[i];
                            }
                        }
                        for (n2 = 0; n2 < ((DistanceArray)object).numRows; ++n2) {
                            if (this.params.verboseMatlab != 1) continue;
                            System.out.println("Sum correlation " + object2[n2]);
                        }
                        n2 = 0;
                        float f2 = object2[0];
                        for (int i = 1; i < ((DistanceArray)object).numRows; ++i) {
                            if (!(object2[i] < f2)) continue;
                            n2 = i;
                            f2 = object2[i];
                        }
                        if (f2 < (float)this.params.epochValidMeanThreshold) {
                            float f3 = 0.0f;
                            for (int i = 0; i < this.params.templateNum; ++i) {
                                float f4;
                                float f5 = this.currentData.templateArray[nArray3[n2][i]].max();
                                if (!(f4 > f3)) continue;
                                f3 = f5;
                            }
                            float f6 = (f3 - (float)this.params.epochValidMaxModifier1) / (float)this.params.epochValidMaxModifier2;
                            for (int i = 0; i < this.params.templatesForDist; ++i) {
                                if (this.params.verboseMatlab != 1) continue;
                                System.out.println("Corr selected " + ((DistanceArray)object).array[n2][nArray3[n2][i]]);
                            }
                            float f7 = ((DistanceArray)object).array[n2][nArray3[n2][this.params.templatesForDist - 1]];
                            if (this.params.templatesForDist == 3) {
                                f7 = Math.max(f7, ((DistanceArray)object).array[nArray3[n2][1]][nArray3[n2][2]]);
                            }
                            float f8 = (float)this.params.epochValidMaxThreshold + f6;
                            if (this.params.verboseMatlab == 1) {
                                System.out.println("Max corr: " + f7 + ", threshold " + f8);
                            }
                            if (f7 < (float)this.params.epochValidMaxThreshold + f6) {
                                this.currentData.selectRows(nArray3[n2]);
                                this.currentData.computeDistance(this.currentData);
                                for (int i = 0; i < this.lastTemplateInd; ++i) {
                                    object2 = this.currentData.computeDistance(this.templates[i]);
                                    this.templates[i].score = ((DistanceArray)object2).mean();
                                }
                                System.nanoTime();
                                return true;
                            }
                        }
                    }
                }
            }
        }
        System.nanoTime();
        return false;
    }
}

