/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.ArrayList;
import org.achartengine.chart.RoundChart;
import org.achartengine.model.MultipleCategorySeries;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public class DoughnutChart
extends RoundChart {
    private MultipleCategorySeries mDataset;
    private int mStep;

    public DoughnutChart(MultipleCategorySeries multipleCategorySeries, DefaultRenderer defaultRenderer) {
        super(null, defaultRenderer);
        this.mDataset = multipleCategorySeries;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        int n5;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int n6 = this.getLegendSize(this.mRenderer, n4 / 5, 0.0f);
        int n7 = n;
        int n8 = n2;
        int n9 = n + n3;
        int n10 = this.mDataset.getCategoriesCount();
        String[] stringArray = new String[n10];
        for (n5 = 0; n5 < n10; ++n5) {
            stringArray[n5] = this.mDataset.getCategory(n5);
        }
        if (this.mRenderer.isFitLegend()) {
            n6 = this.drawLegend(canvas, this.mRenderer, stringArray, n7, n9, n2, n3, n4, n6, paint, true);
        }
        n5 = n2 + n4 - n6;
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint, false, 0);
        this.mStep = 7;
        int n11 = Math.min(Math.abs(n9 - n7), Math.abs(n5 - n8));
        double d = 0.35 * (double)this.mRenderer.getScale();
        double d2 = 0.2 / (double)n10;
        int n12 = (int)((double)n11 * d);
        if (this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (n7 + n9) / 2;
        }
        if (this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (n5 + n8) / 2;
        }
        float f = (float)n12 * 0.9f;
        float f2 = (float)n12 * 1.1f;
        ArrayList<RectF> arrayList = new ArrayList<RectF>();
        for (int i = 0; i < n10; ++i) {
            int n13 = this.mDataset.getItemCount(i);
            double d3 = 0.0;
            String[] stringArray2 = new String[n13];
            for (int j = 0; j < n13; ++j) {
                d3 += this.mDataset.getValues(i)[j];
                stringArray2[j] = this.mDataset.getTitles(i)[j];
            }
            float f3 = 0.0f;
            RectF rectF = new RectF((float)(this.mCenterX - n12), (float)(this.mCenterY - n12), (float)(this.mCenterX + n12), (float)(this.mCenterY + n12));
            for (int j = 0; j < n13; ++j) {
                paint.setColor(this.mRenderer.getSeriesRendererAt(j).getColor());
                float f4 = (float)this.mDataset.getValues(i)[j];
                float f5 = (float)((double)f4 / d3 * 360.0);
                canvas.drawArc(rectF, f3, f5, true, paint);
                this.drawLabel(canvas, this.mDataset.getTitles(i)[j], this.mRenderer, arrayList, this.mCenterX, this.mCenterY, f, f2, f3, f5, n7, n9, paint);
                f3 += f5;
            }
            n12 = (int)((double)n12 - (double)n11 * d2);
            f = (float)((double)f - ((double)n11 * d2 - 2.0));
            if (this.mRenderer.getBackgroundColor() != 0) {
                paint.setColor(this.mRenderer.getBackgroundColor());
            } else {
                paint.setColor(-1);
            }
            paint.setStyle(Paint.Style.FILL);
            rectF = new RectF((float)(this.mCenterX - n12), (float)(this.mCenterY - n12), (float)(this.mCenterX + n12), (float)(this.mCenterY + n12));
            canvas.drawArc(rectF, 0.0f, 360.0f, true, paint);
            --n12;
        }
        arrayList.clear();
        this.drawLegend(canvas, this.mRenderer, stringArray, n7, n9, n2, n3, n4, n6, paint, false);
        this.drawTitle(canvas, n, n2, n3, paint);
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        --this.mStep;
        canvas.drawCircle(f + 10.0f - (float)this.mStep, f2, (float)this.mStep, paint);
    }
}

