/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import java.util.ArrayList;
import java.util.List;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.tools.AbstractTool;
import org.achartengine.tools.ZoomEvent;
import org.achartengine.tools.ZoomListener;

public class Zoom
extends AbstractTool {
    private boolean mZoomIn;
    private float mZoomRate;
    private List<ZoomListener> mZoomListeners = new ArrayList<ZoomListener>();

    public Zoom(AbstractChart abstractChart, boolean bl, float f) {
        super(abstractChart);
        this.mZoomIn = bl;
        this.setZoomRate(f);
    }

    public void setZoomRate(float f) {
        this.mZoomRate = f;
    }

    public void apply() {
        if (this.mChart instanceof XYChart) {
            int n = this.mRenderer.getScalesCount();
            for (int i = 0; i < n; ++i) {
                double d;
                double d2;
                double[] dArray = this.getRange(i);
                this.checkRange(dArray, i);
                double[] dArray2 = this.mRenderer.getZoomLimits();
                boolean bl = dArray2 != null && dArray2.length == 4;
                double d3 = (dArray[0] + dArray[1]) / 2.0;
                double d4 = (dArray[2] + dArray[3]) / 2.0;
                double d5 = dArray[1] - dArray[0];
                double d6 = dArray[3] - dArray[2];
                if (this.mZoomIn) {
                    if (this.mRenderer.isZoomXEnabled()) {
                        d5 /= (double)this.mZoomRate;
                    }
                    if (this.mRenderer.isZoomYEnabled()) {
                        d6 /= (double)this.mZoomRate;
                    }
                } else {
                    if (this.mRenderer.isZoomXEnabled()) {
                        d5 *= (double)this.mZoomRate;
                    }
                    if (this.mRenderer.isZoomYEnabled()) {
                        d6 *= (double)this.mZoomRate;
                    }
                }
                if (this.mRenderer.isZoomXEnabled()) {
                    d2 = d3 - d5 / 2.0;
                    d = d3 + d5 / 2.0;
                    if (!bl || dArray2[0] <= d2 && dArray2[1] >= d) {
                        this.setXRange(d2, d, i);
                    }
                }
                if (!this.mRenderer.isZoomYEnabled()) continue;
                d2 = d4 - d6 / 2.0;
                d = d4 + d6 / 2.0;
                if (bl && (!(dArray2[2] <= d2) || !(dArray2[3] >= d))) continue;
                this.setYRange(d2, d, i);
            }
        } else {
            DefaultRenderer defaultRenderer = ((RoundChart)this.mChart).getRenderer();
            if (this.mZoomIn) {
                defaultRenderer.setScale(defaultRenderer.getScale() * this.mZoomRate);
            } else {
                defaultRenderer.setScale(defaultRenderer.getScale() / this.mZoomRate);
            }
        }
        this.notifyZoomListeners(new ZoomEvent(this.mZoomIn, this.mZoomRate));
    }

    private synchronized void notifyZoomListeners(ZoomEvent zoomEvent) {
        for (ZoomListener zoomListener : this.mZoomListeners) {
            zoomListener.zoomApplied(zoomEvent);
        }
    }

    public synchronized void notifyZoomResetListeners() {
        for (ZoomListener zoomListener : this.mZoomListeners) {
            zoomListener.zoomReset();
        }
    }

    public synchronized void addZoomListener(ZoomListener zoomListener) {
        this.mZoomListeners.add(zoomListener);
    }

    public synchronized void removeZoomListener(ZoomListener zoomListener) {
        this.mZoomListeners.add(zoomListener);
    }
}

