/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import java.util.ArrayList;
import java.util.List;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.tools.AbstractTool;
import org.achartengine.tools.PanListener;

public class Pan
extends AbstractTool {
    private List<PanListener> mPanListeners = new ArrayList<PanListener>();

    public Pan(AbstractChart abstractChart) {
        super(abstractChart);
    }

    public void apply(float f, float f2, float f3, float f4) {
        if (this.mChart instanceof XYChart) {
            int n = this.mRenderer.getScalesCount();
            double[] dArray = this.mRenderer.getPanLimits();
            boolean bl = dArray != null && dArray.length == 4;
            XYChart xYChart = (XYChart)this.mChart;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                boolean bl3;
                double[] dArray2 = this.getRange(i);
                double[] dArray3 = xYChart.getCalcRange(i);
                if (dArray2[0] == dArray2[1] && dArray3[0] == dArray3[1] || dArray2[2] == dArray2[3] && dArray3[2] == dArray3[3]) {
                    return;
                }
                this.checkRange(dArray2, i);
                double[] dArray4 = xYChart.toRealPoint(f, f2, i);
                double[] dArray5 = xYChart.toRealPoint(f3, f4, i);
                double d = dArray4[0] - dArray5[0];
                double d2 = dArray4[1] - dArray5[1];
                if (this.mRenderer.isPanXEnabled()) {
                    if (bl) {
                        bl3 = dArray[0] <= dArray2[0] + d;
                        boolean bl4 = bl2 = dArray[1] >= dArray2[1] + d;
                        if (bl3 && bl2) {
                            this.setXRange(dArray2[0] + d, dArray2[1] + d, i);
                        }
                    } else {
                        this.setXRange(dArray2[0] + d, dArray2[1] + d, i);
                    }
                }
                if (!this.mRenderer.isPanYEnabled()) continue;
                if (bl) {
                    bl3 = dArray[2] <= dArray2[2] + d2;
                    boolean bl5 = bl2 = dArray[3] < dArray2[3] + d2;
                    if (!bl3 || bl2) continue;
                    this.setYRange(dArray2[2] + d2, dArray2[3] + d2, i);
                    continue;
                }
                this.setYRange(dArray2[2] + d2, dArray2[3] + d2, i);
            }
        } else {
            RoundChart roundChart = (RoundChart)this.mChart;
            roundChart.setCenterX(roundChart.getCenterX() + (int)(f3 - f));
            roundChart.setCenterY(roundChart.getCenterY() + (int)(f4 - f2));
        }
        this.notifyPanListeners();
    }

    private synchronized void notifyPanListeners() {
        for (PanListener panListener : this.mPanListeners) {
            panListener.panApplied();
        }
    }

    public synchronized void addPanListener(PanListener panListener) {
        this.mPanListeners.add(panListener);
    }

    public synchronized void removePanListener(PanListener panListener) {
        this.mPanListeners.add(panListener);
    }
}

