/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.ScatterChart;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.BasicStroke;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.util.MathHelper;

public abstract class XYChart
extends AbstractChart {
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float mScale;
    private float mTranslate;
    private Point mCenter;
    private Rect mScreenR;
    private Map<Integer, double[]> mCalcRange = new HashMap<Integer, double[]>();
    private Map<Integer, List<RectF>> clickableAreas = new HashMap<Integer, List<RectF>>();

    protected XYChart() {
    }

    public XYChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        List<Float> list;
        int n5;
        int n6;
        Object object;
        int n7;
        int n8;
        int n9;
        XYMultipleSeriesRenderer.Orientation orientation;
        int n10;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        int n11 = this.getLegendSize(this.mRenderer, n4 / 5, this.mRenderer.getAxisTitleTextSize());
        int[] nArray = this.mRenderer.getMargins();
        int n12 = n + nArray[1];
        int n13 = n2 + nArray[0];
        int n14 = n + n3 - nArray[3];
        int n15 = this.mDataset.getSeriesCount();
        String[] stringArray = new String[n15];
        for (n10 = 0; n10 < n15; ++n10) {
            stringArray[n10] = this.mDataset.getSeriesAt(n10).getTitle();
        }
        if (this.mRenderer.isFitLegend() && this.mRenderer.isShowLegend()) {
            n11 = this.drawLegend(canvas, this.mRenderer, stringArray, n12, n14, n2, n3, n4, n11, paint, true);
        }
        n10 = n2 + n4 - nArray[2] - n11;
        if (this.mScreenR == null) {
            this.mScreenR = new Rect();
        }
        this.mScreenR.set(n12, n13, n14, n10);
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint, false, 0);
        if (paint.getTypeface() == null || !paint.getTypeface().toString().equals(this.mRenderer.getTextTypefaceName()) || paint.getTypeface().getStyle() != this.mRenderer.getTextTypefaceStyle()) {
            paint.setTypeface(Typeface.create((String)this.mRenderer.getTextTypefaceName(), (int)this.mRenderer.getTextTypefaceStyle()));
        }
        if ((orientation = this.mRenderer.getOrientation()) == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            n14 -= n11;
            n10 += n11 - 20;
        }
        boolean bl = (n9 = orientation.getAngle()) == 90;
        this.mScale = (float)n4 / (float)n3;
        this.mTranslate = Math.abs(n3 - n4) / 2;
        if (this.mScale < 1.0f) {
            this.mTranslate *= -1.0f;
        }
        this.mCenter = new Point((n + n3) / 2, (n2 + n4) / 2);
        if (bl) {
            this.transform(canvas, n9, false);
        }
        int n16 = -2147483647;
        for (int i = 0; i < n15; ++i) {
            n16 = Math.max(n16, this.mDataset.getSeriesAt(i).getScaleNumber());
        }
        if (++n16 < 0) {
            return;
        }
        double[] dArray = new double[n16];
        double[] dArray2 = new double[n16];
        double[] dArray3 = new double[n16];
        double[] dArray4 = new double[n16];
        boolean[] blArray = new boolean[n16];
        boolean[] blArray2 = new boolean[n16];
        boolean[] blArray3 = new boolean[n16];
        boolean[] blArray4 = new boolean[n16];
        for (int i = 0; i < n16; ++i) {
            dArray[i] = this.mRenderer.getXAxisMin(i);
            dArray2[i] = this.mRenderer.getXAxisMax(i);
            dArray3[i] = this.mRenderer.getYAxisMin(i);
            dArray4[i] = this.mRenderer.getYAxisMax(i);
            blArray[i] = this.mRenderer.isMinXSet(i);
            blArray2[i] = this.mRenderer.isMaxXSet(i);
            blArray3[i] = this.mRenderer.isMinYSet(i);
            blArray4[i] = this.mRenderer.isMaxYSet(i);
            if (this.mCalcRange.get(i) != null) continue;
            this.mCalcRange.put(i, new double[4]);
        }
        double[] dArray5 = new double[n16];
        double[] dArray6 = new double[n16];
        for (n8 = 0; n8 < n15; ++n8) {
            double d;
            XYSeries xYSeries = this.mDataset.getSeriesAt(n8);
            int n17 = xYSeries.getScaleNumber();
            if (xYSeries.getItemCount() == 0) continue;
            if (!blArray[n17]) {
                d = xYSeries.getMinX();
                dArray[n17] = Math.min(dArray[n17], d);
                this.mCalcRange.get((Object)Integer.valueOf((int)n17))[0] = dArray[n17];
            }
            if (!blArray2[n17]) {
                d = xYSeries.getMaxX();
                dArray2[n17] = Math.max(dArray2[n17], d);
                this.mCalcRange.get((Object)Integer.valueOf((int)n17))[1] = dArray2[n17];
            }
            if (!blArray3[n17]) {
                d = xYSeries.getMinY();
                dArray3[n17] = Math.min(dArray3[n17], (double)((float)d));
                this.mCalcRange.get((Object)Integer.valueOf((int)n17))[2] = dArray3[n17];
            }
            if (blArray4[n17]) continue;
            d = xYSeries.getMaxY();
            dArray4[n17] = Math.max(dArray4[n17], (double)((float)d));
            this.mCalcRange.get((Object)Integer.valueOf((int)n17))[3] = dArray4[n17];
        }
        for (n8 = 0; n8 < n16; ++n8) {
            if (dArray2[n8] - dArray[n8] != 0.0) {
                dArray5[n8] = (double)(n14 - n12) / (dArray2[n8] - dArray[n8]);
            }
            if (dArray4[n8] - dArray3[n8] == 0.0) continue;
            dArray6[n8] = (float)((double)(n10 - n13) / (dArray4[n8] - dArray3[n8]));
        }
        n8 = 0;
        this.clickableAreas = new HashMap<Integer, List<RectF>>();
        for (n7 = 0; n7 < n15; ++n7) {
            int n18;
            XYSeries xYSeries = this.mDataset.getSeriesAt(n7);
            int n19 = xYSeries.getScaleNumber();
            if (xYSeries.getItemCount() == 0) continue;
            n8 = 1;
            object = this.mRenderer.getSeriesRendererAt(n7);
            n6 = n18 = xYSeries.getItemCount();
            n5 = n6 * 2;
            list = new ArrayList<Float>();
            float f = Math.min((float)n10, (float)((double)n10 + dArray6[n19] * dArray3[n19]));
            LinkedList<RectF> linkedList = new LinkedList<RectF>();
            this.clickableAreas.put(n7, linkedList);
            for (int i = 0; i < n5; i += 2) {
                int n20 = i / 2;
                double d = xYSeries.getY(n20);
                if (d != Double.MAX_VALUE) {
                    list.add(Float.valueOf((float)((double)n12 + dArray5[n19] * (xYSeries.getX(n20) - dArray[n19]))));
                    list.add(Float.valueOf((float)((double)n10 - dArray6[n19] * (d - dArray3[n19]))));
                    continue;
                }
                if (this.isRenderNullValues()) {
                    list.add(Float.valueOf((float)((double)n12 + dArray5[n19] * (xYSeries.getX(n20) - dArray[n19]))));
                    list.add(Float.valueOf((float)((double)n10 - dArray6[n19] * -dArray3[n19])));
                    continue;
                }
                if (list.size() > 0) {
                    this.drawSeries(xYSeries, canvas, paint, list, (SimpleSeriesRenderer)object, f, n7, orientation);
                    RectF[] rectFArray = this.clickableAreasForPoints(MathHelper.getFloats(list), f, n7);
                    linkedList.addAll(Arrays.asList(rectFArray));
                    list.clear();
                }
                linkedList.add(null);
            }
            if (list.size() <= 0) continue;
            this.drawSeries(xYSeries, canvas, paint, list, (SimpleSeriesRenderer)object, f, n7, orientation);
            RectF[] rectFArray = this.clickableAreasForPoints(MathHelper.getFloats(list), f, n7);
            linkedList.addAll(Arrays.asList(rectFArray));
        }
        this.drawBackground(this.mRenderer, canvas, n, n10, n3, n4 - n10, paint, true, this.mRenderer.getMarginsColor());
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, nArray[0], paint, true, this.mRenderer.getMarginsColor());
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawBackground(this.mRenderer, canvas, n, n2, n12 - n, n4 - n2, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, n14, n2, nArray[3], n4 - n2, paint, true, this.mRenderer.getMarginsColor());
        } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.drawBackground(this.mRenderer, canvas, n14, n2, n3 - n14, n4 - n2, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, n, n2, n12 - n, n4 - n2, paint, true, this.mRenderer.getMarginsColor());
        }
        n7 = this.mRenderer.isShowLabels() && n8 != 0 ? 1 : 0;
        boolean bl2 = this.mRenderer.isShowGrid();
        boolean bl3 = this.mRenderer.isShowCustomTextGrid();
        if (n7 != 0 || bl2) {
            object = this.getValidLabels(MathHelper.getLabels(dArray[0], dArray2[0], this.mRenderer.getXLabels()));
            HashMap<Integer, List<Double>> hashMap = new HashMap<Integer, List<Double>>();
            for (n6 = 0; n6 < n16; ++n6) {
                hashMap.put(n6, this.getValidLabels(MathHelper.getLabels(dArray3[n6], dArray4[n6], this.mRenderer.getYLabels())));
            }
            n6 = n12;
            if (n7 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                paint.setTextSize(this.mRenderer.getLabelsTextSize());
                paint.setTextAlign(this.mRenderer.getXLabelsAlign());
                if (this.mRenderer.getXLabelsAlign() == Paint.Align.LEFT) {
                    n6 = (int)((float)n6 + this.mRenderer.getLabelsTextSize() / 4.0f);
                }
            }
            this.drawXLabels((List<Double>)object, this.mRenderer.getXTextLabelLocations(), canvas, paint, n6, n13, n10, dArray5[0], dArray[0], dArray2[0]);
            for (n5 = 0; n5 < n16; ++n5) {
                paint.setTextAlign(this.mRenderer.getYLabelsAlign(n5));
                list = (List)hashMap.get(n5);
                int n21 = list.size();
                for (int i = 0; i < n21; ++i) {
                    double d = (Double)((Object)list.get(i));
                    Paint.Align align = this.mRenderer.getYAxisAlign(n5);
                    boolean bl4 = this.mRenderer.getYTextLabel(d, n5) != null;
                    float f = (float)((double)n10 - dArray6[n5] * (d - dArray3[n5]));
                    if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                        if (n7 != 0 && !bl4) {
                            paint.setColor(this.mRenderer.getLabelsColor());
                            if (align == Paint.Align.LEFT) {
                                canvas.drawLine((float)(n12 + this.getLabelLinePos(align)), f, (float)n12, f, paint);
                                this.drawText(canvas, this.getLabel(d), n12, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            } else {
                                canvas.drawLine((float)n14, f, (float)(n14 + this.getLabelLinePos(align)), f, paint);
                                this.drawText(canvas, this.getLabel(d), n14, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            }
                        }
                        if (!bl2) continue;
                        paint.setColor(this.mRenderer.getGridColor());
                        canvas.drawLine((float)n12, f, (float)n14, f, paint);
                        continue;
                    }
                    if (orientation != XYMultipleSeriesRenderer.Orientation.VERTICAL) continue;
                    if (n7 != 0 && !bl4) {
                        paint.setColor(this.mRenderer.getLabelsColor());
                        canvas.drawLine((float)(n14 - this.getLabelLinePos(align)), f, (float)n14, f, paint);
                        this.drawText(canvas, this.getLabel(d), n14 + 10, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                    }
                    if (!bl2) continue;
                    paint.setColor(this.mRenderer.getGridColor());
                    canvas.drawLine((float)n14, f, (float)n12, f, paint);
                }
            }
            if (n7 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                for (n5 = 0; n5 < n16; ++n5) {
                    Double[] doubleArray;
                    list = this.mRenderer.getYAxisAlign(n5);
                    for (Double d : doubleArray = this.mRenderer.getYTextLabelLocations(n5)) {
                        if (!(dArray3[n5] <= d) || !(d <= dArray4[n5])) continue;
                        float f = (float)((double)n10 - dArray6[n5] * (d - dArray3[n5]));
                        String string = this.mRenderer.getYTextLabel(d, n5);
                        paint.setColor(this.mRenderer.getLabelsColor());
                        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                            if (list == Paint.Align.LEFT) {
                                canvas.drawLine((float)(n12 + this.getLabelLinePos((Paint.Align)list)), f, (float)n12, f, paint);
                                this.drawText(canvas, string, n12, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            } else {
                                canvas.drawLine((float)n14, f, (float)(n14 + this.getLabelLinePos((Paint.Align)list)), f, paint);
                                this.drawText(canvas, string, n14, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            }
                            if (!bl3) continue;
                            paint.setColor(this.mRenderer.getGridColor());
                            canvas.drawLine((float)n12, f, (float)n14, f, paint);
                            continue;
                        }
                        canvas.drawLine((float)(n14 - this.getLabelLinePos((Paint.Align)list)), f, (float)n14, f, paint);
                        this.drawText(canvas, string, n14 + 10, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                        if (!bl3) continue;
                        paint.setColor(this.mRenderer.getGridColor());
                        canvas.drawLine((float)n14, f, (float)n12, f, paint);
                    }
                }
            }
            if (n7 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                float f = this.mRenderer.getAxisTitleTextSize();
                paint.setTextSize(f);
                paint.setTextAlign(Paint.Align.CENTER);
                if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n + n3 / 2, (float)n10 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + f, paint, 0.0f);
                    for (int i = 0; i < n16; ++i) {
                        Paint.Align align = this.mRenderer.getYAxisAlign(i);
                        if (align == Paint.Align.LEFT) {
                            this.drawText(canvas, this.mRenderer.getYTitle(i), (float)n + f, n2 + n4 / 2, paint, -90.0f);
                            continue;
                        }
                        this.drawText(canvas, this.mRenderer.getYTitle(i), n + n3, n2 + n4 / 2, paint, -90.0f);
                    }
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), n + n3 / 2, (float)n2 + this.mRenderer.getChartTitleTextSize(), paint, 0.0f);
                } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n + n3 / 2, (float)(n2 + n4) - f, paint, -90.0f);
                    this.drawText(canvas, this.mRenderer.getYTitle(), n14 + 20, n2 + n4 / 2, paint, 0.0f);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), (float)n + f, n13 + n4 / 2, paint, 0.0f);
                }
            }
        }
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawLegend(canvas, this.mRenderer, stringArray, n12, n14, n2, n3, n4, n11, paint, false);
        } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.transform(canvas, n9, true);
            this.drawLegend(canvas, this.mRenderer, stringArray, n12, n14, n2, n3, n4, n11, paint, false);
            this.transform(canvas, n9, false);
        }
        if (this.mRenderer.isShowAxes()) {
            paint.setColor(this.mRenderer.getAxesColor());
            canvas.drawLine((float)n12, (float)n10, (float)n14, (float)n10, paint);
            boolean bl5 = false;
            for (int i = 0; i < n16 && !bl5; ++i) {
                bl5 = this.mRenderer.getYAxisAlign(i) == Paint.Align.RIGHT;
            }
            if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                canvas.drawLine((float)n12, (float)n13, (float)n12, (float)n10, paint);
                if (bl5) {
                    canvas.drawLine((float)n14, (float)n13, (float)n14, (float)n10, paint);
                }
            } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                canvas.drawLine((float)n14, (float)n13, (float)n14, (float)n10, paint);
            }
        }
        if (bl) {
            this.transform(canvas, n9, true);
        }
    }

    protected Rect getScreenR() {
        return this.mScreenR;
    }

    protected void setScreenR(Rect rect) {
        this.mScreenR = rect;
    }

    private List<Double> getValidLabels(List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list);
        for (Double d : list) {
            if (!d.isNaN()) continue;
            arrayList.remove(d);
        }
        return arrayList;
    }

    protected void drawSeries(XYSeries xYSeries, Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, XYMultipleSeriesRenderer.Orientation orientation) {
        ScatterChart scatterChart;
        Object object;
        BasicStroke basicStroke = simpleSeriesRenderer.getStroke();
        Paint.Cap cap = paint.getStrokeCap();
        Paint.Join join = paint.getStrokeJoin();
        float f2 = paint.getStrokeMiter();
        PathEffect pathEffect = paint.getPathEffect();
        Paint.Style style = paint.getStyle();
        if (basicStroke != null) {
            object = null;
            if (basicStroke.getIntervals() != null) {
                object = new DashPathEffect(basicStroke.getIntervals(), basicStroke.getPhase());
            }
            this.setStroke(basicStroke.getCap(), basicStroke.getJoin(), basicStroke.getMiter(), Paint.Style.FILL_AND_STROKE, (PathEffect)object, paint);
        }
        object = MathHelper.getFloats(list);
        this.drawSeries(canvas, paint, (float[])object, simpleSeriesRenderer, f, n);
        if (this.isRenderPoints(simpleSeriesRenderer) && (scatterChart = this.getPointsChart()) != null) {
            scatterChart.drawSeries(canvas, paint, (float[])object, simpleSeriesRenderer, f, n);
        }
        paint.setTextSize(simpleSeriesRenderer.getChartValuesTextSize());
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            paint.setTextAlign(Paint.Align.CENTER);
        } else {
            paint.setTextAlign(Paint.Align.LEFT);
        }
        if (simpleSeriesRenderer.isDisplayChartValues()) {
            paint.setTextAlign(simpleSeriesRenderer.getChartValuesTextAlign());
            this.drawChartValuesText(canvas, xYSeries, simpleSeriesRenderer, paint, (float[])object, n);
        }
        if (basicStroke != null) {
            this.setStroke(cap, join, f2, style, pathEffect, paint);
        }
    }

    private void setStroke(Paint.Cap cap, Paint.Join join, float f, Paint.Style style, PathEffect pathEffect, Paint paint) {
        paint.setStrokeCap(cap);
        paint.setStrokeJoin(join);
        paint.setStrokeMiter(f);
        paint.setPathEffect(pathEffect);
        paint.setStyle(style);
    }

    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, float[] fArray, int n) {
        for (int i = 0; i < fArray.length; i += 2) {
            this.drawText(canvas, this.getLabel(xYSeries.getY(i / 2)), fArray[i], fArray[i + 1] - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
        }
    }

    protected void drawText(Canvas canvas, String string, float f, float f2, Paint paint, float f3) {
        float f4 = (float)(-this.mRenderer.getOrientation().getAngle()) + f3;
        if (f4 != 0.0f) {
            canvas.rotate(f4, f, f2);
        }
        canvas.drawText(string, f, f2, paint);
        if (f4 != 0.0f) {
            canvas.rotate(-f4, f, f2);
        }
    }

    private void transform(Canvas canvas, float f, boolean bl) {
        if (bl) {
            canvas.scale(1.0f / this.mScale, this.mScale);
            canvas.translate(this.mTranslate, -this.mTranslate);
            canvas.rotate(-f, this.mCenter.getX(), this.mCenter.getY());
        } else {
            canvas.rotate(f, this.mCenter.getX(), this.mCenter.getY());
            canvas.translate(-this.mTranslate, this.mTranslate);
            canvas.scale(this.mScale, 1.0f / this.mScale);
        }
    }

    protected String getLabel(double d) {
        String string = "";
        string = d == (double)Math.round(d) ? Math.round(d) + "" : d + "";
        return string;
    }

    protected void drawXLabels(List<Double> list, Double[] doubleArray, Canvas canvas, Paint paint, int n, int n2, int n3, double d, double d2, double d3) {
        int n4 = list.size();
        boolean bl = this.mRenderer.isShowLabels();
        boolean bl2 = this.mRenderer.isShowGrid();
        for (int i = 0; i < n4; ++i) {
            double d4 = list.get(i);
            float f = (float)((double)n + d * (d4 - d2));
            if (bl) {
                paint.setColor(this.mRenderer.getLabelsColor());
                canvas.drawLine(f, (float)n3, f, (float)n3 + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                this.drawText(canvas, this.getLabel(d4), f, (float)n3 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
            }
            if (!bl2) continue;
            paint.setColor(this.mRenderer.getGridColor());
            canvas.drawLine(f, (float)n3, f, (float)n2, paint);
        }
        this.drawXTextLabels(doubleArray, canvas, paint, bl, n, n2, n3, d, d2, d3);
    }

    protected void drawXTextLabels(Double[] doubleArray, Canvas canvas, Paint paint, boolean bl, int n, int n2, int n3, double d, double d2, double d3) {
        boolean bl2 = this.mRenderer.isShowCustomTextGrid();
        if (bl) {
            paint.setColor(this.mRenderer.getLabelsColor());
            for (Double d4 : doubleArray) {
                if (!(d2 <= d4) || !(d4 <= d3)) continue;
                float f = (float)((double)n + d * (d4 - d2));
                paint.setColor(this.mRenderer.getLabelsColor());
                canvas.drawLine(f, (float)n3, f, (float)n3 + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                this.drawText(canvas, this.mRenderer.getXTextLabel(d4), f, (float)n3 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
                if (!bl2) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine(f, (float)n3, f, (float)n2, paint);
            }
        }
    }

    public XYMultipleSeriesRenderer getRenderer() {
        return this.mRenderer;
    }

    public XYMultipleSeriesDataset getDataset() {
        return this.mDataset;
    }

    public double[] getCalcRange(int n) {
        return this.mCalcRange.get(n);
    }

    public void setCalcRange(double[] dArray, int n) {
        this.mCalcRange.put(n, dArray);
    }

    public double[] toRealPoint(float f, float f2) {
        return this.toRealPoint(f, f2, 0);
    }

    public double[] toScreenPoint(double[] dArray) {
        return this.toScreenPoint(dArray, 0);
    }

    private int getLabelLinePos(Paint.Align align) {
        int n = 4;
        if (align == Paint.Align.LEFT) {
            n = -n;
        }
        return n;
    }

    public double[] toRealPoint(float f, float f2, int n) {
        double d = this.mRenderer.getXAxisMin(n);
        double d2 = this.mRenderer.getXAxisMax(n);
        double d3 = this.mRenderer.getYAxisMin(n);
        double d4 = this.mRenderer.getYAxisMax(n);
        return new double[]{(double)(f - (float)this.mScreenR.left) * (d2 - d) / (double)this.mScreenR.width() + d, (double)((float)(this.mScreenR.top + this.mScreenR.height()) - f2) * (d4 - d3) / (double)this.mScreenR.height() + d3};
    }

    public double[] toScreenPoint(double[] dArray, int n) {
        double d = this.mRenderer.getXAxisMin(n);
        double d2 = this.mRenderer.getXAxisMax(n);
        double d3 = this.mRenderer.getYAxisMin(n);
        double d4 = this.mRenderer.getYAxisMax(n);
        if (!(this.mRenderer.isMinXSet(n) && this.mRenderer.isMaxXSet(n) && this.mRenderer.isMinXSet(n) && this.mRenderer.isMaxYSet(n))) {
            double[] dArray2 = this.getCalcRange(n);
            d = dArray2[0];
            d2 = dArray2[1];
            d3 = dArray2[2];
            d4 = dArray2[3];
        }
        return new double[]{(dArray[0] - d) * (double)this.mScreenR.width() / (d2 - d) + (double)this.mScreenR.left, (d4 - dArray[1]) * (double)this.mScreenR.height() / (d4 - d3) + (double)this.mScreenR.top};
    }

    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        if (this.clickableAreas != null) {
            for (int i = this.clickableAreas.size() - 1; i >= 0; --i) {
                int n = 0;
                if (this.clickableAreas.get(i) == null) continue;
                for (RectF rectF : this.clickableAreas.get(i)) {
                    if (rectF != null && rectF.contains(point.getX(), point.getY())) {
                        XYSeries xYSeries = this.mDataset.getSeriesAt(i);
                        return new SeriesSelection(i, n, xYSeries.getX(n), xYSeries.getY(n));
                    }
                    ++n;
                }
            }
        }
        return super.getSeriesAndPointForScreenCoordinate(point);
    }

    public abstract void drawSeries(Canvas var1, Paint var2, float[] var3, SimpleSeriesRenderer var4, float var5, int var6);

    protected abstract RectF[] clickableAreasForPoints(float[] var1, float var2, int var3);

    protected boolean isRenderNullValues() {
        return false;
    }

    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return false;
    }

    public double getDefaultMinimum() {
        return Double.MAX_VALUE;
    }

    public ScatterChart getPointsChart() {
        return null;
    }

    public abstract String getChartType();
}

