/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.RoundChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.renderer.DialRenderer;

public class DialChart
extends RoundChart {
    private static final int NEEDLE_RADIUS = 10;
    private DialRenderer mRenderer;

    public DialChart(CategorySeries categorySeries, DialRenderer dialRenderer) {
        super(categorySeries, dialRenderer);
        this.mRenderer = dialRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        double d;
        int n5;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int n6 = this.getLegendSize(this.mRenderer, n4 / 5, 0.0f);
        int n7 = n;
        int n8 = n2;
        int n9 = n + n3;
        int n10 = this.mDataset.getItemCount();
        String[] stringArray = new String[n10];
        for (n5 = 0; n5 < n10; ++n5) {
            stringArray[n5] = this.mDataset.getCategory(n5);
        }
        if (this.mRenderer.isFitLegend()) {
            n6 = this.drawLegend(canvas, this.mRenderer, stringArray, n7, n9, n2, n3, n4, n6, paint, true);
        }
        n5 = n2 + n4 - n6;
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint, false, 0);
        int n11 = Math.min(Math.abs(n9 - n7), Math.abs(n5 - n8));
        int n12 = (int)((double)n11 * 0.35 * (double)this.mRenderer.getScale());
        if (this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (n7 + n9) / 2;
        }
        if (this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (n5 + n8) / 2;
        }
        float f = (float)n12 * 0.9f;
        float f2 = (float)n12 * 1.1f;
        double d2 = this.mRenderer.getMinValue();
        double d3 = this.mRenderer.getMaxValue();
        double d4 = this.mRenderer.getAngleMin();
        double d5 = this.mRenderer.getAngleMax();
        if (!this.mRenderer.isMinValueSet() || !this.mRenderer.isMaxValueSet()) {
            int n13 = this.mRenderer.getSeriesRendererCount();
            for (int i = 0; i < n13; ++i) {
                d = this.mDataset.getValue(i);
                if (!this.mRenderer.isMinValueSet()) {
                    d2 = Math.min(d2, d);
                }
                if (this.mRenderer.isMaxValueSet()) continue;
                d3 = Math.max(d3, d);
            }
        }
        if (d2 == d3) {
            d2 *= 0.5;
            d3 *= 1.5;
        }
        paint.setColor(this.mRenderer.getLabelsColor());
        double d6 = this.mRenderer.getMinorTicksSpacing();
        d = this.mRenderer.getMajorTicksSpacing();
        if (d6 == Double.MAX_VALUE) {
            d6 = (d3 - d2) / 30.0;
        }
        if (d == Double.MAX_VALUE) {
            d = (d3 - d2) / 10.0;
        }
        this.drawTicks(canvas, d2, d3, d4, d5, this.mCenterX, this.mCenterY, f2, n12, d6, paint, false);
        this.drawTicks(canvas, d2, d3, d4, d5, this.mCenterX, this.mCenterY, f2, f, d, paint, true);
        int n14 = this.mRenderer.getSeriesRendererCount();
        for (int i = 0; i < n14; ++i) {
            double d7 = this.getAngleForValue(this.mDataset.getValue(i), d4, d5, d2, d3);
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            boolean bl = this.mRenderer.getVisualTypeForIndex(i) == DialRenderer.Type.ARROW;
            this.drawNeedle(canvas, d7, this.mCenterX, this.mCenterY, f, bl, paint);
        }
        this.drawLegend(canvas, this.mRenderer, stringArray, n7, n9, n2, n3, n4, n6, paint, false);
        this.drawTitle(canvas, n, n2, n3, paint);
    }

    private double getAngleForValue(double d, double d2, double d3, double d4, double d5) {
        double d6 = d3 - d2;
        double d7 = d5 - d4;
        return Math.toRadians(d2 + (d - d4) * d6 / d7);
    }

    private void drawTicks(Canvas canvas, double d, double d2, double d3, double d4, int n, int n2, double d5, double d6, double d7, Paint paint, boolean bl) {
        for (double d8 = d; d8 <= d2; d8 += d7) {
            double d9 = this.getAngleForValue(d8, d3, d4, d, d2);
            double d10 = Math.sin(d9);
            double d11 = Math.cos(d9);
            int n3 = Math.round((float)n + (float)(d6 * d10));
            int n4 = Math.round((float)n2 + (float)(d6 * d11));
            int n5 = Math.round((float)n + (float)(d5 * d10));
            int n6 = Math.round((float)n2 + (float)(d5 * d11));
            canvas.drawLine((float)n3, (float)n4, (float)n5, (float)n6, paint);
            if (!bl) continue;
            paint.setTextAlign(Paint.Align.LEFT);
            if (n3 <= n5) {
                paint.setTextAlign(Paint.Align.RIGHT);
            }
            String string = d8 + "";
            if (Math.round(d8) == (long)d8) {
                string = (long)d8 + "";
            }
            canvas.drawText(string, (float)n3, (float)n4, paint);
        }
    }

    private void drawNeedle(Canvas canvas, double d, int n, int n2, double d2, boolean bl, Paint paint) {
        float[] fArray;
        double d3 = Math.toRadians(90.0);
        int n3 = (int)(10.0 * Math.sin(d - d3));
        int n4 = (int)(10.0 * Math.cos(d - d3));
        int n5 = (int)(d2 * Math.sin(d));
        int n6 = (int)(d2 * Math.cos(d));
        int n7 = n + n5;
        int n8 = n2 + n6;
        if (bl) {
            int n9 = n + (int)(d2 * 0.85 * Math.sin(d));
            int n10 = n2 + (int)(d2 * 0.85 * Math.cos(d));
            fArray = new float[]{n9 - n3, n10 - n4, n7, n8, n9 + n3, n10 + n4};
            float f = paint.getStrokeWidth();
            paint.setStrokeWidth(5.0f);
            canvas.drawLine((float)n, (float)n2, (float)n7, (float)n8, paint);
            paint.setStrokeWidth(f);
        } else {
            fArray = new float[]{n - n3, n2 - n4, n7, n8, n + n3, n2 + n4};
        }
        this.drawPath(canvas, fArray, paint, true);
    }
}

