/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import java.io.Serializable;
import java.util.List;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public abstract class AbstractChart
implements Serializable {
    public abstract void draw(Canvas var1, int var2, int var3, int var4, int var5, Paint var6);

    protected void drawBackground(DefaultRenderer defaultRenderer, Canvas canvas, int n, int n2, int n3, int n4, Paint paint, boolean bl, int n5) {
        if (defaultRenderer.isApplyBackgroundColor() || bl) {
            if (bl) {
                paint.setColor(n5);
            } else {
                paint.setColor(defaultRenderer.getBackgroundColor());
            }
            paint.setStyle(Paint.Style.FILL);
            canvas.drawRect((float)n, (float)n2, (float)(n + n3), (float)(n2 + n4), paint);
        }
    }

    protected int drawLegend(Canvas canvas, DefaultRenderer defaultRenderer, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6, Paint paint, boolean bl) {
        float f = 32.0f;
        if (defaultRenderer.isShowLegend()) {
            float f2 = n;
            float f3 = (float)(n3 + n5 - n6) + f;
            paint.setTextAlign(Paint.Align.LEFT);
            paint.setTextSize(defaultRenderer.getLegendTextSize());
            int n7 = Math.min(stringArray.length, defaultRenderer.getSeriesRendererCount());
            for (int i = 0; i < n7; ++i) {
                float f4 = this.getLegendShapeWidth(i);
                String string = stringArray[i];
                if (stringArray.length == defaultRenderer.getSeriesRendererCount()) {
                    paint.setColor(defaultRenderer.getSeriesRendererAt(i).getColor());
                } else {
                    paint.setColor(-3355444);
                }
                float[] fArray = new float[string.length()];
                paint.getTextWidths(string, fArray);
                float f5 = 0.0f;
                for (float f6 : fArray) {
                    f5 += f6;
                }
                float f7 = f4 + 10.0f + f5;
                float f8 = f2 + f7;
                if (i > 0 && this.getExceed(f8, defaultRenderer, n2, n4)) {
                    f2 = n;
                    f3 += defaultRenderer.getLegendTextSize();
                    f += defaultRenderer.getLegendTextSize();
                    f8 = f2 + f7;
                }
                if (this.getExceed(f8, defaultRenderer, n2, n4)) {
                    float f9 = (float)n2 - f2 - f4 - 10.0f;
                    if (this.isVertical(defaultRenderer)) {
                        f9 = (float)n4 - f2 - f4 - 10.0f;
                    }
                    int n8 = paint.breakText(string, true, f9, fArray);
                    string = string.substring(0, n8) + "...";
                }
                if (!bl) {
                    this.drawLegendShape(canvas, defaultRenderer.getSeriesRendererAt(i), f2, f3, i, paint);
                    canvas.drawText(string, f2 + f4 + 5.0f, f3 + 5.0f, paint);
                }
                f2 += f7;
            }
        }
        return Math.round(f + defaultRenderer.getLegendTextSize());
    }

    protected boolean getExceed(float f, DefaultRenderer defaultRenderer, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = f > (float)n;
        if (this.isVertical(defaultRenderer)) {
            bl = f > (float)n2;
        }
        return bl;
    }

    protected boolean isVertical(DefaultRenderer defaultRenderer) {
        return defaultRenderer instanceof XYMultipleSeriesRenderer && ((XYMultipleSeriesRenderer)defaultRenderer).getOrientation() == XYMultipleSeriesRenderer.Orientation.VERTICAL;
    }

    protected void drawPath(Canvas canvas, float[] fArray, Paint paint, boolean bl) {
        Path path = new Path();
        path.moveTo(fArray[0], fArray[1]);
        for (int i = 2; i < fArray.length; i += 2) {
            path.lineTo(fArray[i], fArray[i + 1]);
        }
        if (bl) {
            path.lineTo(fArray[0], fArray[1]);
        }
        canvas.drawPath(path, paint);
    }

    public abstract int getLegendShapeWidth(int var1);

    public abstract void drawLegendShape(Canvas var1, SimpleSeriesRenderer var2, float var3, float var4, int var5, Paint var6);

    private String getFitText(String string, float f, Paint paint) {
        String string2 = string;
        int n = string.length();
        int n2 = 0;
        while (paint.measureText(string2) > f && n2 < n) {
            string2 = string.substring(0, n - ++n2) + "...";
        }
        if (n2 == n) {
            string2 = "...";
        }
        return string2;
    }

    protected int getLegendSize(DefaultRenderer defaultRenderer, int n, float f) {
        int n2 = defaultRenderer.getLegendHeight();
        if (defaultRenderer.isShowLegend() && n2 == 0) {
            n2 = n;
        }
        if (!defaultRenderer.isShowLegend() && defaultRenderer.isShowLabels()) {
            n2 = (int)(defaultRenderer.getLabelsTextSize() * 4.0f / 3.0f + f);
        }
        return n2;
    }

    protected void drawLabel(Canvas canvas, String string, DefaultRenderer defaultRenderer, List<RectF> list, int n, int n2, float f, float f2, float f3, float f4, int n3, int n4, Paint paint) {
        if (defaultRenderer.isShowLabels()) {
            paint.setColor(defaultRenderer.getLabelsColor());
            double d = Math.toRadians(90.0f - (f3 + f4 / 2.0f));
            double d2 = Math.sin(d);
            double d3 = Math.cos(d);
            int n5 = Math.round((float)n + (float)((double)f * d2));
            int n6 = Math.round((float)n2 + (float)((double)f * d3));
            int n7 = Math.round((float)n + (float)((double)f2 * d2));
            int n8 = Math.round((float)n2 + (float)((double)f2 * d3));
            float f5 = defaultRenderer.getLabelsTextSize();
            float f6 = Math.max(f5 / 2.0f, 10.0f);
            paint.setTextAlign(Paint.Align.LEFT);
            if (n5 > n7) {
                f6 = -f6;
                paint.setTextAlign(Paint.Align.RIGHT);
            }
            float f7 = (float)n7 + f6;
            float f8 = n8;
            float f9 = (float)n4 - f7;
            if (n5 > n7) {
                f9 = f7 - (float)n3;
            }
            string = this.getFitText(string, f9, paint);
            float f10 = paint.measureText(string);
            boolean bl = false;
            while (!bl) {
                boolean bl2 = false;
                int n9 = list.size();
                for (int i = 0; i < n9 && !bl2; ++i) {
                    RectF rectF = list.get(i);
                    if (!rectF.intersects(f7, f8, f7 + f10, f8 + f5)) continue;
                    bl2 = true;
                    f8 = Math.max(f8, rectF.bottom);
                }
                bl = !bl2;
            }
            n8 = (int)(f8 - f5 / 2.0f);
            canvas.drawLine((float)n5, (float)n6, (float)n7, (float)n8, paint);
            canvas.drawLine((float)n7, (float)n8, (float)n7 + f6, (float)n8, paint);
            canvas.drawText(string, f7, f8, paint);
            list.add(new RectF(f7, f8, f7 + f10, f8 + f5));
        }
    }

    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        return null;
    }
}

