/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.graphics.RectF;
import android.view.MotionEvent;
import org.achartengine.GraphicalView;
import org.achartengine.ITouchHandler;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.tools.Pan;
import org.achartengine.tools.PanListener;
import org.achartengine.tools.ZoomListener;

public class TouchHandlerOld
implements ITouchHandler {
    private DefaultRenderer mRenderer;
    private float oldX;
    private float oldY;
    private RectF zoomR = new RectF();
    private Pan mPan;
    private GraphicalView graphicalView;

    public TouchHandlerOld(GraphicalView graphicalView, AbstractChart abstractChart) {
        this.graphicalView = graphicalView;
        this.zoomR = this.graphicalView.getZoomRectangle();
        this.mRenderer = abstractChart instanceof XYChart ? ((XYChart)abstractChart).getRenderer() : ((RoundChart)abstractChart).getRenderer();
        if (this.mRenderer.isPanEnabled()) {
            this.mPan = new Pan((XYChart)abstractChart);
        }
    }

    @Override
    public boolean handleTouch(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (this.mRenderer != null && n == 2) {
            if (this.oldX >= 0.0f || this.oldY >= 0.0f) {
                float f = motionEvent.getX();
                float f2 = motionEvent.getY();
                if (this.mRenderer.isPanEnabled()) {
                    this.mPan.apply(this.oldX, this.oldY, f, f2);
                }
                this.oldX = f;
                this.oldY = f2;
                this.graphicalView.repaint();
                return true;
            }
        } else if (n == 0) {
            this.oldX = motionEvent.getX();
            this.oldY = motionEvent.getY();
            if (this.mRenderer != null && this.mRenderer.isZoomEnabled() && this.zoomR.contains(this.oldX, this.oldY)) {
                if (this.oldX < this.zoomR.left + this.zoomR.width() / 3.0f) {
                    this.graphicalView.zoomIn();
                } else if (this.oldX < this.zoomR.left + this.zoomR.width() * 2.0f / 3.0f) {
                    this.graphicalView.zoomOut();
                } else {
                    this.graphicalView.zoomReset();
                }
                return true;
            }
        } else if (n == 1) {
            this.oldX = 0.0f;
            this.oldY = 0.0f;
        }
        return !this.mRenderer.isClickEnabled();
    }

    @Override
    public void addZoomListener(ZoomListener zoomListener) {
    }

    @Override
    public void removeZoomListener(ZoomListener zoomListener) {
    }

    @Override
    public void addPanListener(PanListener panListener) {
        if (this.mPan != null) {
            this.mPan.addPanListener(panListener);
        }
    }

    @Override
    public void removePanListener(PanListener panListener) {
        if (this.mPan != null) {
            this.mPan.removePanListener(panListener);
        }
    }
}

