/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.graphics.RectF;
import android.view.MotionEvent;
import org.achartengine.GraphicalView;
import org.achartengine.ITouchHandler;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.tools.Pan;
import org.achartengine.tools.PanListener;
import org.achartengine.tools.Zoom;
import org.achartengine.tools.ZoomListener;

public class TouchHandler
implements ITouchHandler {
    private DefaultRenderer mRenderer;
    private float oldX;
    private float oldY;
    private float oldX2;
    private float oldY2;
    private RectF zoomR = new RectF();
    private Pan mPan;
    private Zoom mPinchZoom;
    private GraphicalView graphicalView;

    public TouchHandler(GraphicalView graphicalView, AbstractChart abstractChart) {
        this.graphicalView = graphicalView;
        this.zoomR = this.graphicalView.getZoomRectangle();
        this.mRenderer = abstractChart instanceof XYChart ? ((XYChart)abstractChart).getRenderer() : ((RoundChart)abstractChart).getRenderer();
        if (this.mRenderer.isPanEnabled()) {
            this.mPan = new Pan(abstractChart);
        }
        if (this.mRenderer.isZoomEnabled()) {
            this.mPinchZoom = new Zoom(abstractChart, true, 1.0f);
        }
    }

    @Override
    public boolean handleTouch(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (this.mRenderer != null && n == 2) {
            if (this.oldX >= 0.0f || this.oldY >= 0.0f) {
                float f = motionEvent.getX(0);
                float f2 = motionEvent.getY(0);
                if (motionEvent.getPointerCount() > 1 && (this.oldX2 >= 0.0f || this.oldY2 >= 0.0f) && this.mRenderer.isZoomEnabled()) {
                    float f3 = motionEvent.getX(1);
                    float f4 = motionEvent.getY(1);
                    float f5 = Math.abs(f - f3);
                    float f6 = Math.abs(f2 - f4);
                    float f7 = Math.abs(this.oldX - this.oldX2);
                    float f8 = Math.abs(this.oldY - this.oldY2);
                    float f9 = 1.0f;
                    f9 = Math.abs(f - this.oldX) >= Math.abs(f2 - this.oldY) ? f5 / f7 : f6 / f8;
                    if ((double)f9 > 0.909 && (double)f9 < 1.1) {
                        this.mPinchZoom.setZoomRate(f9);
                        this.mPinchZoom.apply();
                    }
                    this.oldX2 = f3;
                    this.oldY2 = f4;
                } else if (this.mRenderer.isPanEnabled()) {
                    this.mPan.apply(this.oldX, this.oldY, f, f2);
                    this.oldX2 = 0.0f;
                    this.oldY2 = 0.0f;
                }
                this.oldX = f;
                this.oldY = f2;
                this.graphicalView.repaint();
                return true;
            }
        } else if (n == 0) {
            this.oldX = motionEvent.getX(0);
            this.oldY = motionEvent.getY(0);
            if (this.mRenderer != null && this.mRenderer.isZoomEnabled() && this.zoomR.contains(this.oldX, this.oldY)) {
                if (this.oldX < this.zoomR.left + this.zoomR.width() / 3.0f) {
                    this.graphicalView.zoomIn();
                } else if (this.oldX < this.zoomR.left + this.zoomR.width() * 2.0f / 3.0f) {
                    this.graphicalView.zoomOut();
                } else {
                    this.graphicalView.zoomReset();
                }
                return true;
            }
        } else if (n == 1 || n == 6) {
            this.oldX = 0.0f;
            this.oldY = 0.0f;
            this.oldX2 = 0.0f;
            this.oldY2 = 0.0f;
            if (n == 6) {
                this.oldX = -1.0f;
                this.oldY = -1.0f;
            }
        }
        return !this.mRenderer.isClickEnabled();
    }

    @Override
    public void addZoomListener(ZoomListener zoomListener) {
        if (this.mPinchZoom != null) {
            this.mPinchZoom.addZoomListener(zoomListener);
        }
    }

    @Override
    public void removeZoomListener(ZoomListener zoomListener) {
        if (this.mPinchZoom != null) {
            this.mPinchZoom.removeZoomListener(zoomListener);
        }
    }

    @Override
    public void addPanListener(PanListener panListener) {
        if (this.mPan != null) {
            this.mPan.addPanListener(panListener);
        }
    }

    @Override
    public void removePanListener(PanListener panListener) {
        if (this.mPan != null) {
            this.mPan.removePanListener(panListener);
        }
    }
}

