/*
 * Decompiled with CFR 0.152.
 */
package com.neurosky.thinkgear;

import android.util.Log;
import com.neurosky.thinkgear.BlinkFilter;
import com.neurosky.thinkgear.FFT;
import com.neurosky.thinkgear.FFTResult;

public class Positivity {
    private BlinkFilter a;
    private FFT b;
    private FFTResult c;
    private byte d = (byte)-56;
    private float[] e;
    private float[] f;
    private float[] g;
    private float[] h;
    private float[] i;
    private float[] j;
    private float[] k;
    private float[] l;
    private float[] m;
    private short n = (short)5120;
    private short o = 0;
    private short p = (short)512;
    private double q;
    private int r;
    private double[] s;
    private double[] t;
    private double u;
    private double v;
    private double[] w;
    private double[] x;
    private double y;
    private double z;

    public Positivity() {
        this.a = new BlinkFilter(512);
        this.b = new FFT();
        this.e = new float[this.n];
        this.f = new float[this.n];
        this.g = new float[this.n];
        this.h = new float[this.p];
        this.j = new float[this.p];
        this.l = new float[this.p];
        this.m = new float[this.p];
        this.i = new float[this.p];
        this.k = new float[this.p];
        this.s = new double[6];
        this.t = new double[10];
        this.w = new double[6];
        this.x = new double[10];
    }

    public double detect(byte by, short n, short s) {
        if (by == this.d) {
            System.arraycopy(this.e, 1, this.g, 0, this.n - 1);
            this.g[this.n - 1] = n;
            System.arraycopy(this.g, 0, this.e, 0, this.n);
            System.arraycopy(this.f, 1, this.g, 0, this.n - 1);
            this.g[this.n - 1] = s;
            System.arraycopy(this.g, 0, this.f, 0, this.n);
            this.o = (short)(this.o + 1);
            if (this.o == this.n) {
                Log.v((String)"TGDevice", (String)"Calculating positivity");
                this.o = (short)(this.p * 9);
                this.h = this.a.filter(by, this.e);
                this.j = this.a.filter(by, this.f);
                by = (byte)this.p;
                n = this.n / this.p;
                float[] fArray = new float[by];
                this.v = 0.0;
                this.z = 0.0;
                for (int i = 0; i < n; ++i) {
                    int n2;
                    for (n2 = 0; n2 < this.p; ++n2) {
                        this.i[n2] = this.h[i * this.p + n2];
                        this.k[n2] = this.j[i * this.p + n2];
                    }
                    this.c = this.b.calculateFFT(this.i, fArray, 1, by);
                    this.l = this.c.getPower();
                    this.c = this.b.calculateFFT(this.k, fArray, 1, by);
                    this.m = this.c.getPower();
                    for (n2 = 8; n2 <= 13; ++n2) {
                        this.s[n2 - 8] = this.l[n2];
                        this.w[n2 - 8] = this.m[n2];
                    }
                    this.t[i] = Positivity.a(this.s);
                    this.x[i] = Positivity.a(this.w);
                }
                this.r = 0;
                while (this.r < this.t.length) {
                    this.v += this.t[this.r];
                    this.z += this.x[this.r];
                    ++this.r;
                }
                this.u = this.v / (double)this.t.length;
                this.y = this.z / (double)this.x.length;
                this.q = (this.y - this.u) / (this.y + this.u) * 100.0;
                if (this.q > 25.0) {
                    this.q = 25.0;
                } else if (this.q < -25.0) {
                    this.q = -25.0;
                }
                this.q *= 4.0;
                return this.q;
            }
            return 200.0;
        }
        this.e = new float[this.n];
        this.f = new float[this.n];
        this.o = 0;
        return 200.0;
    }

    private static double a(double[] dArray) {
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }
}

