{
    /**
    _test_jso_encode(): Tests jso_encode_*() functions.
    JSOnion version: 1.0.0d
    */
    
    var original, expected, actual;
    
    //jso_encode_real() --- Positive
    expected = 3.1415;
    actual = jso_encode_real(3.1415);
    assert_equal(expected, real(actual), "jso_encode_real() failed to encode positive real!");
    
    //jso_encode_real() --- Negative
    expected = -2.71828;
    actual = jso_encode_real(-2.71828);
    assert_equal(expected, real(actual), "jso_encode_real() failed to encode negative real!");
    
    //jso_encode_real() --- Zero
    expected = 0;
    actual = jso_encode_integer(0);
    assert_equal(expected, real(actual), "jso_encode_real() failed to encode zero!");
    
    //jso_encode_integer() --- Positive
    expected = "2345";
    actual = jso_encode_integer(2345);
    assert_equal(expected, actual, "jso_encode_integer() failed to encode positive integer!");
    
    //jso_encode_integer() --- Negative
    expected = "-45";
    actual = jso_encode_integer(-45);
    assert_equal(expected, actual, "jso_encode_integer() failed to encode negative integer!");
    
    //jso_encode_integer() --- Zero
    expected = "0";
    actual = jso_encode_integer(0);
    assert_equal(expected, actual, "jso_encode_integer() failed to encode zero!");
    
    //jso_encode_boolean() --- true
    expected = "true";
    actual = jso_encode_boolean(true);
    assert_equal(expected, actual, "jso_encode_boolean() failed to encode true!");
    
    //jso_encode_boolean() --- false
    expected = "false";
    actual = jso_encode_boolean(false);
    assert_equal(expected, actual, "jso_encode_boolean() failed to encode false!");
    
    //jso_encode_string() --- Simple string
    expected = '"waahoo"';
    actual = jso_encode_string("waahoo");
    assert_equal(expected, actual, "jso_encode_string() failed to encode simple string!");
    
    //jso_encode_string() --- Empty string
    expected = '""';
    actual = jso_encode_string("");
    assert_equal(expected, actual, "jso_encode_string() failed to encode empty string!");
    
    //jso_encode_string() --- Basic escape characters
    expected = '"\\\"\b\f\n\r\t"';
    actual = jso_encode_string('\"' + chr(8) + chr(12) + chr(10) + chr(13) + chr(9));
    assert_equal(expected, actual, "jso_encode_string() failed to encode escape character string!");
    
    //jso_encode_map() --- Empty map
    var empty_map;
    empty_map = jso_new_map();
    expected = "{}";
    actual = jso_encode_map(empty_map);
    assert_equal(expected, actual, "jso_encode_map() failed to encode empty map!");
    jso_cleanup_map(empty_map);
    
    //jso_encode_map() --- One-element map
    var one_map;
    one_map = jso_new_map();
    jso_map_add_string(one_map, "key", "value");
    expected = '{"key":"value"}';
    actual = jso_encode_map(one_map);
    assert_equal(expected, actual, "jso_encode_map() failed to encode one-element map!");
    jso_cleanup_map(one_map);
    
    //jso_encode_map() --- Multi-element map
    var multi_map, ok1, ok2;
    multi_map = jso_new_map();
    jso_map_add_string(multi_map, "key1", "value\1");
    jso_map_add_integer(multi_map, "key2", 2);
    ok1 = '{"key1":"value\\1","key2":2}';
    ok2 = '{"key2":2,"key1":"value\\1"}';
    actual = jso_encode_map(multi_map);
    assert_true((actual == ok1) || (actual == ok2), "jso_encode_map() failed to encode multi-element map!");
    jso_cleanup_map(multi_map);
    
    //jso_encode_list() --- Empty list
    var empty_list;
    empty_list = jso_new_list();
    expected = "[]";
    actual = jso_encode_list(empty_list);
    assert_equal(expected, actual, "jso_encode_list() failed to encode empty list!");
    jso_cleanup_list(empty_list);
    
    //jso_encode_list() --- One-element nested list
    var one_list;
    one_list = jso_new_list();
    jso_list_add_submap(one_list, jso_new_map());
    expected = "[{}]";
    actual = jso_encode_list(one_list);
    assert_equal(expected, actual, "jso_encode_list() failed to encode one-element nested list!");
    jso_cleanup_list(one_list);
    
    //jso_encode_list() --- Multi-element nested list
    var multi_list, submap, sublist;
    multi_list = jso_new_list();
    submap = jso_new_map();
        jso_map_add_string(submap, "1", "one");
    jso_list_add_submap(multi_list, submap);
    jso_list_add_integer(multi_list, 2);
    sublist = jso_new_list();
        jso_list_add_string(sublist, "three");
        jso_list_add_boolean(sublist, true);
    jso_list_add_sublist(multi_list, sublist);
    expected = '[{"1":"one"},2,["three",true]]';
    actual = jso_encode_list(multi_list);
    assert_equal(expected, actual, "jso_encode_list() failed to encode one-element nested list!");
    jso_cleanup_list(multi_list);
}
