{
    /**
    _test_jso_map_add(): Test jso_map_add_*() functions.
    JSOnion version: 1.0.0d
    */
    
    var expected, actual, key, map;
    map = jso_new_map();
    
    //jso_map_add_real()
    expected = pi;
    key = "pi";
    jso_map_add_real(map, key, expected);
    actual = jso_map_get(map, key);
    assert_true(ds_map_exists(map, key), "jso_map_add_real() failed to add the number.");
    assert_equal(expected, actual, "jso_map_add_real() added the wrong number.");
    ds_map_delete(map, key);
    
    //jso_map_add_string()
    expected = "waahoo";
    key = "str";
    jso_map_add_string(map, key, expected);
    actual = jso_map_get(map, key);
    assert_true(ds_map_exists(map, key), "jso_map_add_string() failed to add the string.");
    assert_equal(expected, actual, "jso_map_add_string() added the wrong string.");
    ds_map_delete(map, key);
    
    //jso_map_add_sublist()
    expected = jso_new_list();
    key = "sublist";
    jso_map_add_sublist(map, key, expected);
    actual = jso_map_get(map, key);
    assert_true(ds_map_exists(map, key), "jso_map_add_sublist() failed to add the new sublist.");
    assert_equal(expected, actual, "jso_map_add_sublist() added the wrong sublist.");
    ds_map_delete(map, key);
    ds_list_destroy(expected);
    
    //jso_map_add_submap()
    expected = jso_new_map();
    key = "sublist";
    jso_map_add_sublist(map, key, expected);
    actual = jso_map_get(map, key);
    assert_true(ds_map_exists(map, key), "jso_map_add_submap() failed to add the new submap.");
    assert_equal(expected, actual, "jso_map_add_submap() added the wrong submap.");
    ds_map_delete(map, key);
    ds_map_destroy(expected);
    
    //jso_map_add_integer()
    expected = 2345;
    key = "integer";
    jso_map_add_integer(map, key, expected);
    actual = jso_map_get(map, key);
    assert_true(ds_map_exists(map, key), "jso_map_add_integer() failed to add the new integer.");
    assert_equal(expected, actual, "jso_map_add_integer() added the wrong integer.");
    ds_map_delete(map, key);
    
    //jso_map_add_boolean() --- true
    expected = true;
    key = "booleantrue";
    jso_map_add_boolean(map, key, expected);
    actual = jso_map_get(map, key);
    assert_true(ds_map_exists(map, key), "jso_map_add_boolean() failed to add true.");
    assert_true(actual, "jso_map_add_boolean() added the wrong true.");
    ds_map_delete(map, key);
    
    //jso_map_add_boolean() --- false
    expected = false;
    key = "booleanfalse";
    jso_map_add_boolean(map, key, expected);
    actual = jso_map_get(map, key)
    assert_true(ds_map_exists(map, key), "jso_map_add_boolean() failed to add false.");
    assert_false(actual, "jso_map_add_boolean() added the wrong false.");
    ds_map_delete(map, key);
    
    //Cleanup
    ds_map_destroy(map);
}
