{
    /**
    _test_jso_list_add(): Test jso_list_add_*() functions.
    JSOnion version: 1.0.0d
    */
    
    var expected, actual, list;
    list = jso_new_list();
    
    //jso_list_add_real()
    expected = pi;
    jso_list_add_real(list, expected);
    actual = jso_list_get(list, 0);
    assert_false(ds_list_empty(list), "jso_list_add_real() failed to add the number.");
    assert_equal(expected, actual, "jso_list_add_real() added the wrong number.");
    ds_list_clear(list);
    
    //jso_list_add_string()
    expected = "waahoo";
    jso_list_add_string(list, expected);
    actual = jso_list_get(list, 0);
    assert_false(ds_list_empty(list), "jso_list_add_string() failed to add the string.");
    assert_equal(expected, actual, "jso_list_add_string() added the wrong string.");
    ds_list_clear(list);
    
    //jso_list_add_sublist()
    expected = jso_new_list();
    jso_list_add_sublist(list, expected);
    actual = jso_list_get(list, 0);
    assert_false(ds_list_empty(list), "jso_list_add_sublist() failed to add the sublist.");
    assert_equal(expected, actual, "jso_list_add_sublist() added the wrong sublist.");
    ds_list_clear(list);
    ds_list_destroy(expected);
    
    //jso_list_add_submap()
    expected = jso_new_map();
    jso_list_add_submap(list, expected);
    actual = jso_list_get(list, 0);
    assert_false(ds_list_empty(list), "jso_list_add_submap() failed to add the submap.");
    assert_equal(expected, actual, "jso_list_add_submap() added the wrong submap.");
    ds_list_clear(list);
    ds_map_destroy(expected);
    
    //jso_list_add_integer()
    expected = 2345;
    jso_list_add_integer(list, expected);
    actual = jso_list_get(list, 0);
    assert_false(ds_list_empty(list), "jso_list_add_integer() failed to add integer.");
    assert_equal(expected, actual, "jso_list_add_integer() added the wrong integer.");
    ds_list_clear(list);
    
    //jso_list_add_boolean() --- true
    expected = true;
    jso_list_add_boolean(list, expected);
    actual = jso_list_get(list, 0);
    assert_false(ds_list_empty(list), "jso_list_add_boolean() failed to add boolean true.");
    assert_true(actual, "jso_list_add_boolean() added the wrong boolean true.");
    ds_list_clear(list);
    
    //jso_list_add_boolean() --- false
    expected = false;
    jso_list_add_boolean(list, expected);
    actual = jso_list_get(list, 0);
    assert_false(ds_list_empty(list), "jso_list_add_boolean() failed to add boolean false.");
    assert_false(actual, "jso_list_add_boolean() added the wrong boolean false.");
    ds_list_clear(list);
    
    //Cleanup
    ds_list_destroy(list);
}
