{
    /**
    _test_jso_compare(): Test basic jso_compare_*() functions.
    JSOnion version: 1.0.0d
    */
    var a, b;
    
    //jso_compare_maps(): Empty maps should equal each other
    a = jso_new_map();
    b = jso_new_map();
    assert_true(jso_compare_maps(a, b), "Empty maps should equal each other. (#1)");
    assert_true(jso_compare_maps(b, a), "Empty maps should equal each other. (#2)");
    jso_cleanup_map(a);
    jso_cleanup_map(b);
    
    //jso_compare_maps(): An empty map should not equal a filled map
    a = jso_new_map();
    b = jso_new_map();
    jso_map_add_string(b, "junk", "info");
    jso_map_add_integer(b, "taxi", 1729);
    assert_false(jso_compare_maps(a, b), "An empty map should not equal a filled map. (#1)");
    assert_false(jso_compare_maps(b, a), "An empty map should not equal a filled map. (#2)");
    jso_cleanup_map(a);
    jso_cleanup_map(b);
    
    //jso_compare_maps(): Maps with same content entered in different orders should equal each other
    a = jso_new_map();
    b = jso_new_map();
    jso_map_add_real(a, "A", 1);
    jso_map_add_real(a, "B", 2);
    jso_map_add_real(a, "C", 3);
    jso_map_add_real(b, "C", 3);
    jso_map_add_real(b, "A", 1);
    jso_map_add_real(b, "B", 2);
    assert_true(jso_compare_maps(a, b), "Maps with same content entered in different orders should equal each other. (#1)");
    assert_true(jso_compare_maps(b, a), "Maps with same content entered in different orders should equal each other. (#2)");
    jso_cleanup_map(a);
    jso_cleanup_map(b);
    
    //jso_compare_maps(): Maps with different keys should not equal each other
    a = jso_new_map();
    b = jso_new_map();
    jso_map_add_real(a, "A", 1);
    jso_map_add_real(a, "B", 2);
    jso_map_add_real(a, "C", 3);
    jso_map_add_real(b, "D", 3);
    jso_map_add_real(b, "A", 1);
    jso_map_add_real(b, "B", 2);
    assert_false(jso_compare_maps(a, b), "Maps with different keys should not equal each other. (#1)");
    assert_false(jso_compare_maps(b, a), "Maps with different keys should not equal each other. (#2)");
    jso_cleanup_map(a);
    jso_cleanup_map(b);
    
    //jso_compare_maps(): Maps with different values should not equal each other
    a = jso_new_map();
    b = jso_new_map();
    jso_map_add_real(a, "A", 5);
    jso_map_add_real(a, "B", 6);
    jso_map_add_real(a, "C", 9);
    jso_map_add_real(b, "A", 5);
    jso_map_add_real(b, "B", 6);
    jso_map_add_real(b, "C", 8);
    assert_false(jso_compare_maps(a, b), "Maps with different values should not equal each other. (#1)");
    assert_false(jso_compare_maps(b, a), "Maps with different values should not equal each other. (#2)");
    jso_cleanup_map(a);
    jso_cleanup_map(b);
    
    //jso_compare_maps(): Maps with corresponding values of different types should not equal each other, and should not crash.
    a = jso_new_map();
    b = jso_new_map();
    jso_map_add_real(a, "A", 5);
    jso_map_add_real(a, "B", 6);
    jso_map_add_real(a, "C", 8);
    jso_map_add_real(b, "A", 5);
    jso_map_add_string(b, "B", "six");
    jso_map_add_real(b, "C", 8);
    assert_false(jso_compare_maps(a, b), "Maps with corresponding values of different types should not equal each other, and should not crash. (#1)");
    assert_false(jso_compare_maps(b, a), "Maps with corresponding values of different types should not equal each other, and should not crash. (#2)");
    jso_cleanup_map(a);
    jso_cleanup_map(b);
    
    //jso_compare_lists(): Empty lists should equal each other
    a = jso_new_list();
    b = jso_new_list();
    assert_true(jso_compare_lists(a, b), "Empty lists should equal each other. (#1)");
    assert_true(jso_compare_lists(b, a), "Empty lists should equal each other. (#2)");
    jso_cleanup_list(a);
    jso_cleanup_list(b);
    
    //jso_compare_lists(): An empty list should not equal a filled list
    a = jso_new_list();
    b = jso_new_list();
    jso_list_add_string(b, "junk");
    jso_list_add_integer(b, 1729);
    assert_false(jso_compare_lists(a, b), "An empty list should not equal a filled list. (#1)");
    assert_false(jso_compare_lists(b, a), "An empty list should not equal a filled list. (#2)");
    jso_cleanup_list(a);
    jso_cleanup_list(b);
    
    //jso_compare_lists(): Lists with same content entered in different orders should not equal each other
    a = jso_new_list();
    b = jso_new_list();
    jso_list_add_real(a, 1);
    jso_list_add_real(a, 2);
    jso_list_add_real(a, 3);
    jso_list_add_real(b, 3);
    jso_list_add_real(b, 1);
    jso_list_add_real(b, 2);
    assert_false(jso_compare_lists(a, b), "Lists with same content entered in different orders should not equal each other. (#1)");
    assert_false(jso_compare_lists(b, a), "Lists with same content entered in different orders should not equal each other. (#2)");
    jso_cleanup_list(a);
    jso_cleanup_list(b);
    
    //jso_compare_lists(): Lists with corresponding entries of different types should not equal each other, should also not crash.
    a = jso_new_list();
    b = jso_new_list();
    jso_list_add_real(a, 1);
    jso_list_add_real(a, 2);
    jso_list_add_real(a, 3);
    jso_list_add_real(b, 1);
    jso_list_add_string(b, "two");
    jso_list_add_real(b, 3);
    assert_false(jso_compare_lists(a, b), "Lists with corresponding entries of different types should not equal each other, should also not crash. (#1)");
    assert_false(jso_compare_lists(b, a), "Lists with corresponding entries of different types should not equal each other, should also not crash. (#2)");
    jso_cleanup_list(a);
    jso_cleanup_list(b);
}
