{
    /**
    assert_equal(expected, result, errormsg): Display error <errormsg> unless <expected> and <result> are equal.
    */
    
    //Safe equality check; won't crash even if the two are different types
    var match;
    match = is_string(argument0) == is_string(argument1);
    if (match) {
        match = argument0 == argument1;
    }

    //No match?
    if (!match) {
        //Data types
        var type;
        type[0] = "(Real)";
        type[1] = "(String)";
        
        //Construct message
        var msg;
        msg = argument2;
        //Add expected value
        msg += string_repeat(_assert_newline(), 2);
        msg += "Expected " + type[is_string(argument0)] + ":" + _assert_newline();
        msg += _assert_debug_value(argument0);
        //Add actual value
        msg += string_repeat(_assert_newline(), 2);
        msg += "Actual " + type[is_string(argument1)] + ":" + _assert_newline();
        msg += _assert_debug_value(argument1);
        
        //Display message
        _assert_error_popup(msg);
    }
}
