{
    /**
    _assert_debug_value(val): Returns a low-level debug value for the value <val>.
    <val> can be a string or a real value.
    */
    
    //String
    if (is_string(argument0)) {
        if (os_browser == browser_not_a_browser) {
            return argument0;
        } else {
            return string_replace_all(argument0, "#", "\#");
        }
    }
    
    //Numeric --- use GMTuple's algorithm
    else {
    
        //Integers
        if (frac(argument0) == 0) {
            return string(argument0);
        }
        
        //Decimal numbers; get exponent and mantissa  
        var mantissa, exponent;
        exponent = floor(log10(abs(argument0)));
        mantissa = string_format(argument0/power(10,exponent), 15, 14);
        //Look for trailing zeros in the mantissa
        var i, ca;
        i = string_length(mantissa);
        do {
            ca = string_char_at(mantissa, i);
            i -= 1;
        } until (ca != "0")
        //Remove the dot if only the first digit of the normalized mantissa is nonzero
        if (ca != ".") {
            mantissa = string_copy(mantissa, 1, i+1);
        }
        else {
            mantissa = string_copy(mantissa, 1, i);
        }
        //Remove the exponent if it is 0
        if (exponent != 0) {
            return mantissa + "e" + string(exponent);
        } else {
            return mantissa;
        }
    
    //GMTuple algorithm done
    }
}
