/*
 * Decompiled with CFR 0.152.
 */
package com.neurosky.android;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public class NeuroSkyUtil {
    private static final String LOGGER_TAG = "NeuroSkyUtil";
    private static final boolean LOGGER_ENABLE = false;

    public static int getRawWaveValue(byte highOrderByte, byte lowOrderByte) {
        int value = (highOrderByte << 8 | lowOrderByte) & 0xFFFF;
        return value;
    }

    public static int getEEGPowerValue(byte highOrderByte, byte middleOrderByte, byte lowOrderByte) {
        int value = (highOrderByte << 16 | middleOrderByte << 8 | lowOrderByte) & 0xFFFFFF;
        return value;
    }

    public static void printStackTrace2Log(String tag, Throwable exception) {
        StackTraceElement[] elements = exception.getStackTrace();
        StringBuffer stackTrace = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            stackTrace.append("at ").append(elements[i].getClassName());
            stackTrace.append(".").append(elements[i].getMethodName());
            stackTrace.append("(").append(elements[i].getFileName());
            stackTrace.append(":").append(elements[i].getLineNumber()).append(")");
            Log.d((String)tag, (String)stackTrace.toString());
            stackTrace.setLength(0);
            ++i;
        }
    }

    public static void notify2Toast(Handler handler, int notify, String text) {
        Message message = handler.obtainMessage(notify);
        Bundle bundle = new Bundle();
        bundle.putString("toast", text);
        message.setData(bundle);
        handler.sendMessage(message);
    }
}

