/*
 * Decompiled with CFR 0.152.
 */
package com.neurosky.android;

import android.os.Handler;
import com.neurosky.android.NeuroData;
import com.neurosky.android.NeuroRawData;
import com.neurosky.android.NeuroSkyUtil;

public class NeuroStreamParser {
    public static final int PARSER_CODE_POOR_SIGNAL = 2;
    public static final int PARSER_CODE_ATTENTION = 4;
    public static final int PARSER_CODE_MEDITATION = 5;
    public static final int PARSER_CODE_RAW = 128;
    public static final int PARSER_CODE_EEG_POWERS = 131;
    public static final int PST_PACKET_CHECKSUM_FAILED = -2;
    public static final int PST_NOT_YET_COMPLETE_PACKET = 0;
    public static final int PST_PACKET_PARSED_SUCCESS = 1;
    public static final int MESSAGE_READ_RAW_DATA_PACKET = 17;
    public static final int MESSAGE_READ_DIGEST_DATA_PACKET = 18;
    private static final int RAW_DATA_BYTE_LENGTH = 2;
    private static final int EEG_POWERS_BYTE_LENGTH = 24;
    private static final int PARSER_SYNC_BYTE = 170;
    private static final int PARSER_EXCODE_BYTE = 85;
    private static final int MULTI_BYTE_CODE_THRESHOLD = 127;
    private static final int PARSER_STATE_SYNC = 1;
    private static final int PARSER_STATE_SYNC_CHECK = 2;
    private static final int PARSER_STATE_PAYLOAD_LENGTH = 3;
    private static final int PARSER_STATE_PAYLOAD = 4;
    private static final int PARSER_STATE_CHKSUM = 5;
    private static final int PARSER_STATE_WAIT_HIGH = 6;
    private static final int PARSER_STATE_WAIT_LOW = 7;
    private static final String LOGGER_TAG = "NEURO_SKY";
    private static final boolean LOGGER_ENABLE = false;
    private Handler handler;
    private boolean rawDataEnable;
    private int parserStatus;
    private int payloadLength;
    private int payloadBytesReceived;
    private int payloadSum;
    private int checksum;
    private byte[] payload = new byte[256];

    public NeuroStreamParser() {
    }

    public NeuroStreamParser(Handler handler, boolean rawDataEnable) {
        this.handler = handler;
        this.rawDataEnable = rawDataEnable;
        this.parserStatus = 1;
    }

    public int parseByte(byte buffer) {
        int returnValue = 0;
        switch (this.parserStatus) {
            case 1: {
                if ((buffer & 0xFF) != 170) break;
                this.parserStatus = 2;
                break;
            }
            case 2: {
                if ((buffer & 0xFF) == 170) {
                    this.parserStatus = 3;
                    break;
                }
                this.parserStatus = 1;
                break;
            }
            case 3: {
                this.payloadLength = buffer & 0xFF;
                this.payloadBytesReceived = 0;
                this.payloadSum = 0;
                this.parserStatus = 4;
                break;
            }
            case 4: {
                this.payload[this.payloadBytesReceived++] = buffer;
                this.payloadSum += buffer & 0xFF;
                if (this.payloadBytesReceived < this.payloadLength) break;
                this.parserStatus = 5;
                break;
            }
            case 5: {
                this.checksum = buffer & 0xFF;
                this.parserStatus = 1;
                if (this.checksum != (~this.payloadSum & 0xFF)) {
                    returnValue = -2;
                    break;
                }
                returnValue = 1;
                this.parsePacketPayload();
                break;
            }
            case 6: {
                break;
            }
        }
        return returnValue;
    }

    /*
     * Unable to fully structure code
     */
    private void parsePacketPayload() {
        i = 0;
        extendedCodeLevel = 0;
        code = 0;
        valueBytesLength = 0;
        delta = 0;
        theta = 0;
        lowAlpha = 0;
        highAlpha = 0;
        lowBeta = 0;
        highBeta = 0;
        lowGammma = 0;
        midGamma = 0;
        signal = 0;
        attention = 0;
        meditation = 0;
        rawWaveData = 0;
        ** GOTO lbl54
        {
            ++extendedCodeLevel;
            ++i;
            do {
                if (this.payload[i] == 85) continue block6;
                valueBytesLength = (code = this.payload[i++] & 255) > 127 ? this.payload[i++] & 255 : 1;
                if (code == 128) {
                    if (valueBytesLength == 2 && this.rawDataEnable) {
                        highOrderByte = this.payload[i];
                        lowOrderByte = this.payload[i + 1];
                        rawWaveData = NeuroSkyUtil.getRawWaveValue(highOrderByte, lowOrderByte);
                    }
                    i += valueBytesLength;
                    continue;
                }
                switch (code) {
                    case 2: {
                        signal = this.payload[i] & 255;
                        i += valueBytesLength;
                        break;
                    }
                    case 4: {
                        attention = this.payload[i] & 255;
                        i += valueBytesLength;
                        break;
                    }
                    case 5: {
                        meditation = this.payload[i] & 255;
                        i += valueBytesLength;
                        break;
                    }
                    case 131: {
                        if (valueBytesLength == 24) {
                            delta = NeuroSkyUtil.getEEGPowerValue(this.payload[i], this.payload[i + 1], this.payload[i + 2]);
                            theta = NeuroSkyUtil.getEEGPowerValue(this.payload[i + 3], this.payload[i + 4], this.payload[i + 5]);
                            lowAlpha = NeuroSkyUtil.getEEGPowerValue(this.payload[i + 6], this.payload[i + 7], this.payload[i + 8]);
                            highAlpha = NeuroSkyUtil.getEEGPowerValue(this.payload[i + 9], this.payload[i + 10], this.payload[i + 11]);
                            lowBeta = NeuroSkyUtil.getEEGPowerValue(this.payload[i + 12], this.payload[i + 13], this.payload[i + 14]);
                            highBeta = NeuroSkyUtil.getEEGPowerValue(this.payload[i + 15], this.payload[i + 16], this.payload[i + 17]);
                            lowGammma = NeuroSkyUtil.getEEGPowerValue(this.payload[i + 18], this.payload[i + 19], this.payload[i + 20]);
                            midGamma = NeuroSkyUtil.getEEGPowerValue(this.payload[i + 21], this.payload[i + 22], this.payload[i + 23]);
                        }
                        i += valueBytesLength;
                    }
                }
lbl54:
                // 7 sources

            } while (i < this.payloadLength);
        }
        if (code == 128 && this.rawDataEnable) {
            rawData = new NeuroRawData(rawWaveData);
            this.handler.obtainMessage(17, (Object)rawData).sendToTarget();
        } else if (code == 4 || code == 131 || code == 5 || code == 2) {
            data = new NeuroData(signal, delta, theta, lowAlpha, highAlpha, lowBeta, highBeta, lowGammma, midGamma, attention, meditation);
            this.handler.obtainMessage(18, (Object)data).sendToTarget();
        }
        this.parserStatus = 1;
    }
}

