﻿package  {
	import flash.display.*;
    import flash.events.*;                      //for event handling
    import flash.net.Socket;                    //sockets
    import com.adobe.serialization.json.*;      //as3corelib JSON support
	import fl.transitions.*;                    //for animation
	import fl.transitions.easing.*;             //for animation
	
	public class DisplayWindow extends Sprite {
		
		// Constants:
		// Public Properties:
		public var attention:uint;
		public var meditation:uint;
		public var poorSignal:uint;
		
		// Private Properties:
	    private var thinkGearSocket : Socket;
		private var circle:Sprite;
		private var rawWave:Sprite;
		private var rawValues:Array;
		
		// Initialization:
		public function DisplayWindow() {
          
		  rawValues = new Array(512);
		  
		  circle = new Sprite();
		  rawWave = new Sprite();
		  
		  rawWave.x = 10;
		  rawWave.y = 20;		  
		  
		  circle.graphics.beginFill(0xFF0000);
		  circle.graphics.drawCircle(275, 0, 40);
		  circle.graphics.endFill();
		  
		  addChild(circle);
		  
		  //Send configuration to ThinkGear Connector to turn on JSON output
		  var configuration : Object = new Object();
          configuration["enableRawOutput"] = true;
          configuration["format"] = "Json";	 		  
          
		  thinkGearSocket = new Socket();  
		  thinkGearSocket.connect("127.0.0.1", 13854); 
          thinkGearSocket.writeUTFBytes(JSON.encode(configuration));
		  
		  thinkGearSocket.addEventListener(ProgressEvent.SOCKET_DATA, dataHandler);
		}
	
		// Public Methods:
		// Protected Methods:
		private function dataHandler(e : ProgressEvent){
	      //read data from the socket
		  var packetString : String = thinkGearSocket.readUTFBytes(thinkGearSocket.bytesAvailable);
          thinkGearSocket.flush();
          
		  //split the data into an array
	      var packets : Array = packetString.split(/\r/);
          var data:Object;
		  //iterate through array elements
	      for each (var packet:String in packets){
            //sometimes the packet is empty
			if(packet != "") {
		      try {
			  	data = JSON.decode(packet);
				//trace(packet);
			  } catch ( jError: JSONParseError) {
				  // do exception handling here
				  label1.text = jError.text;
		  
			  }
		
			  if(data["rawEeg"] != null) {
				  	label2.text = "Raw:" + data["rawEeg"].toString();
		      }
			  //the main packet
		      if(data["poorSignalLevel"] != null) {
			    poorSignal = data["poorSignalLevel"];
				var yTween:Tween;
				if(poorSignal == 0) {		      
				  attention = data["eSense"]["attention"];
				  meditation = data["eSense"]["meditation"];
				  
				  var newPos:int = 350 - (attention * 3.5);
                  yTween = new Tween(circle, "y", Elastic.easeOut, circle.y, newPos, 0.95, true);
				  
				} /* if(poorSignal == 0) */
				else {
				  if(poorSignal == 200) {	
				    attention = 0;
				    meditation = 0;
					yTween = new Tween(circle, "y", Strong.easeOut, circle.y, 350, 0.95, true);
				  } /* if(poorSignal == 200) */
				} /* else */					
		      }
			}
			data = null;
			//update the label
			label1.text = "Attention: " + attention.toString() + "\nMeditation: " + meditation.toString() + "\nPoor Signal: " + poorSignal.toString();
          } /*for each*/
        } /*function dataHandler*/
	}	
} /* package */