/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.tasks;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.flexunit.ant.FlexUnitSocketServer;
import org.flexunit.ant.FlexUnitSocketThread;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.FlexUnitLauncher;
import org.flexunit.ant.report.Reports;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexUnitTask
extends Task {
    private static final String TRUE = "true";
    private static final String DEFAULT_REPORT_PATH = ".";
    private static final String DEFAULT_SNAPSHOT_FILENAME = "snapshot.jpg";
    private static final int FLOOR_FOR_PORT = 1;
    private static final int SHORTEST_SOCKET_TIMEOUT = 5000;
    private static final List<String> VALID_PLAYERS = Arrays.asList("flash", "air");
    private static final List<String> VALID_XCOMMANDS = Arrays.asList("xvfb", "xvnc");
    private Reports reports = new Reports();
    private boolean verbose = false;
    private int port = 1024;
    private int socketTimeout = 60000;
    private int serverBufferSize = 262144;
    private boolean failOnTestFailure = false;
    private boolean isLocalTrusted = false;
    private String failureProperty = "flexunit.failed";
    private String player = "flash";
    private boolean headless = false;
    private String xcommand = "xvfb";
    private boolean snapshot = false;
    private File snapshotFile = null;
    private File swf = null;
    private File reportDir = null;

    public void setLocalTrusted(boolean bl) {
        this.isLocalTrusted = bl;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setTimeout(int n) {
        this.socketTimeout = n;
    }

    public void setBuffer(int n) {
        this.serverBufferSize = n;
    }

    public void setSWF(String string) {
        this.swf = this.getProject().resolveFile(string);
    }

    public void setToDir(String string) {
        this.reportDir = this.getProject().resolveFile(string);
    }

    public void setHaltonfailure(boolean bl) {
        this.failOnTestFailure = bl;
    }

    public void setFailureproperty(String string) {
        this.failureProperty = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        LoggingUtil.VERBOSE = bl;
    }

    public void setPlayer(String string) {
        this.player = string;
    }

    public void setHeadless(boolean bl) {
        this.headless = bl;
    }

    public void setXcommand(String string) {
        this.xcommand = string;
    }

    public void setSnapshot(boolean bl) {
        this.snapshot = bl;
    }

    public void setSnapshotFile(String string) {
        this.snapshotFile = this.getProject().resolveFile(string);
    }

    public void execute() throws BuildException {
        this.validateInputs();
        this.generateDefaultValues();
        try {
            Future<Object> future = this.setupSocketThread();
            this.launchTestSuite();
            future.get();
            this.analyzeReports();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void validateInputs() {
        LoggingUtil.log("Validating task attributes ...");
        if (this.swf == null || !this.swf.exists()) {
            throw new BuildException("The provided 'swf' property value [" + this.swf.getPath() + "] could not be found.");
        }
        if (this.port < 1) {
            throw new BuildException("The provided 'port' property value [" + this.port + "] must be great than " + 1 + DEFAULT_REPORT_PATH);
        }
        if (this.socketTimeout < 5000) {
            throw new BuildException("The provided 'timeout' property value [" + this.socketTimeout + "] must be great than " + 5000 + DEFAULT_REPORT_PATH);
        }
        if (this.reportDir != null && !this.reportDir.exists()) {
            LoggingUtil.log("Provided report directory path [" + this.reportDir.getPath() + "] does not exist.");
        }
        if (!VALID_PLAYERS.contains(this.player)) {
            throw new BuildException("The provided 'player' property value [" + this.player + "] must be either of the following values: " + VALID_PLAYERS.toString() + DEFAULT_REPORT_PATH);
        }
        if (this.headless) {
            if (!VALID_XCOMMANDS.contains(this.xcommand)) {
                throw new BuildException("The provided 'xcommand' property value [" + this.xcommand + "] must be either of the following values: " + VALID_XCOMMANDS.toString() + DEFAULT_REPORT_PATH);
            }
            if (this.snapshotFile != null && !this.snapshotFile.getParentFile().exists()) {
                LoggingUtil.log("Provided path specified in 'snapshotFile' [" + this.snapshotFile.getPath() + "] cannot be created; the parent directory does not exist.");
            }
        }
    }

    private void generateDefaultValues() {
        LoggingUtil.log("Generating default values ...");
        if (this.reportDir == null || !this.reportDir.exists()) {
            this.reportDir = this.getProject().resolveFile(DEFAULT_REPORT_PATH);
            LoggingUtil.log("Using default reporting dir [" + this.reportDir.getAbsolutePath() + "]");
        }
        this.reportDir.mkdir();
        if (this.snapshotFile == null || !this.snapshotFile.getParentFile().exists()) {
            this.snapshotFile = this.getProject().resolveFile(this.reportDir.getAbsoluteFile() + "/" + DEFAULT_SNAPSHOT_FILENAME);
            LoggingUtil.log("Using default snapshot file path [" + this.snapshotFile.getAbsolutePath() + "]");
        }
        this.logInputValues();
    }

    private void logInputValues() {
        LoggingUtil.log("Using the following settings:");
        LoggingUtil.log("\thaltonfailure: [" + this.failOnTestFailure + "]");
        LoggingUtil.log("\theadless: [" + this.headless + "]");
        LoggingUtil.log("\tlocalTrusted: [" + this.isLocalTrusted + "]");
        LoggingUtil.log("\tplayer: [" + this.player + "]");
        LoggingUtil.log("\tport: [" + this.port + "]");
        LoggingUtil.log("\tsnapshot: [" + this.snapshot + "]");
        LoggingUtil.log("\tsnapshotFile: [" + (this.snapshotFile != null ? this.snapshotFile.getAbsolutePath() : null) + "]");
        LoggingUtil.log("\tswf: [" + this.swf + "]");
        LoggingUtil.log("\ttimeout: [" + this.socketTimeout + "ms]");
        LoggingUtil.log("\ttoDir: [" + this.reportDir.getAbsolutePath() + "]");
        LoggingUtil.log("\tverbose: [" + this.verbose + "]");
        LoggingUtil.log("\txcommand: [" + this.xcommand + "]");
    }

    private void launchTestSuite() {
        FlexUnitLauncher flexUnitLauncher = new FlexUnitLauncher(this.getProject(), this.isLocalTrusted, this.headless, this.player, this.xcommand, this.snapshot, this.snapshotFile);
        try {
            flexUnitLauncher.runTests(this.swf);
        }
        catch (Exception exception) {
            throw new BuildException("Error launching the test runner.", (Throwable)exception);
        }
    }

    private Future<Object> setupSocketThread() {
        LoggingUtil.log("Setting up server process ...");
        boolean bl = !this.isLocalTrusted && this.player.equals("flash");
        FlexUnitSocketServer flexUnitSocketServer = new FlexUnitSocketServer(this.port, this.socketTimeout, this.serverBufferSize, bl);
        FlexUnitSocketThread flexUnitSocketThread = new FlexUnitSocketThread(flexUnitSocketServer, this.reportDir, this.reports);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        return executorService.submit(flexUnitSocketThread);
    }

    private void analyzeReports() {
        LoggingUtil.log("Analyzing reports ...");
        LoggingUtil.log("\n" + this.reports.getSummary(), true);
        if (this.reports.hasFailures()) {
            this.getProject().setNewProperty(this.failureProperty, TRUE);
            if (this.failOnTestFailure) {
                throw new BuildException("FlexUnit tests failed during the test run.");
            }
        }
    }
}

