/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher.commands.player;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.commands.player.PlayerCommand;

public abstract class FlashPlayerCommand
extends PlayerCommand {
    public static final String TRUST_FILENAME = "flexUnit.cfg";
    private boolean localTrusted;

    public void setSwf(File file) {
        super.setSwf(file);
        this.getCommandLine().setExecutable(this.generateExecutable());
        this.getCommandLine().addArguments(this.generateArguments(file));
    }

    public void setLocalTrusted(boolean bl) {
        this.localTrusted = bl;
    }

    public boolean isLocalTrusted() {
        return this.localTrusted;
    }

    public int execute() throws IOException {
        if (this.localTrusted) {
            this.createLocalTrust(this.getSwf());
        } else {
            this.clearLocalTrust();
        }
        return super.execute();
    }

    private void createLocalTrust(File file) {
        try {
            File file2 = this.getLocalTrustDirectory();
            if (!file2.exists()) {
                file2.mkdir();
            }
            File file3 = this.getProject().resolveFile(this.getLocalTrustDirectory() + "/" + TRUST_FILENAME);
            String string = file.getParentFile().getAbsolutePath();
            FileWriter fileWriter = new FileWriter(file3.getAbsolutePath());
            fileWriter.write(string);
            fileWriter.close();
            LoggingUtil.log("Created local trust file at [" + file3.getAbsolutePath() + "]");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void clearLocalTrust() {
        try {
            File file = this.getProject().resolveFile(this.getLocalTrustDirectory() + "/" + TRUST_FILENAME);
            if (file.exists()) {
                file.delete();
                LoggingUtil.log("Deleted existing local trust file at [" + file + "].");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract File getLocalTrustDirectory();

    protected abstract String generateExecutable();

    protected abstract String[] generateArguments(File var1);
}

