/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher.commands.player;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.commands.player.PlayerCommand;

public abstract class AdlCommand
extends PlayerCommand {
    private final String DESCRIPTOR_TEMPLATE = "flexUnitDescriptor.template";
    private final String DESCRIPTOR_FILE = "flexUnitDescriptor.xml";

    public void setSwf(File file) {
        super.setSwf(file);
        this.getCommandLine().setExecutable(this.generateExecutable());
        this.getCommandLine().addArguments(new String[]{file.getParentFile().getAbsolutePath() + "/" + "flexUnitDescriptor.xml"});
    }

    private void createApplicationDescriptor(File file) {
        try {
            URLResource uRLResource = new URLResource(((Object)((Object)this)).getClass().getResource("/flexUnitDescriptor.template"));
            File file2 = new File(file.getParentFile().getAbsolutePath() + "/" + "flexUnitDescriptor.xml");
            FilterSet filterSet = new FilterSet();
            filterSet.addFilter("ADL_SWF", file.getName());
            ResourceUtils.copyResource((Resource)uRLResource, (Resource)new FileResource(file2), (FilterSetCollection)new FilterSetCollection(filterSet), null, (boolean)true, (boolean)false, null, null, (Project)this.getProject());
            LoggingUtil.log("Created application descriptor at [" + file2.getAbsolutePath() + "]");
        }
        catch (Exception exception) {
            throw new BuildException("Could not create application descriptor");
        }
    }

    public int execute() throws IOException {
        this.createApplicationDescriptor(this.getSwf());
        return super.execute();
    }

    private String generateExecutable() {
        return this.getProject().getProperty("FLEX_HOME") + "/bin/" + this.getAdlFilename();
    }

    protected abstract String getAdlFilename();
}

