/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.Project;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.CommandFactory;
import org.flexunit.ant.launcher.OperatingSystem;
import org.flexunit.ant.launcher.commands.player.PlayerCommand;

public class FlexUnitLauncher {
    private static final String WINDOWS_OS = "Windows";
    private static final String MAC_OS_X = "Mac OS X";
    private boolean localTrusted;
    private boolean headless;
    private boolean snapshot;
    private String player;
    private String xcommand;
    private File snapshotFile;
    private Project project;
    private OperatingSystem os;

    public FlexUnitLauncher(Project project, boolean bl, boolean bl2, String string, String string2, boolean bl3, File file) {
        this.project = project;
        this.localTrusted = bl;
        this.headless = bl2;
        this.snapshot = bl3;
        this.player = string;
        this.xcommand = string2;
        this.snapshotFile = file;
        this.os = this.identifyOperatingSystem();
    }

    private OperatingSystem identifyOperatingSystem() {
        OperatingSystem operatingSystem = null;
        String string = System.getProperty("os.name");
        if (string.startsWith(WINDOWS_OS)) {
            LoggingUtil.log("OS: [Windows]");
            operatingSystem = OperatingSystem.WINDOWS;
        } else if (string.startsWith(MAC_OS_X)) {
            LoggingUtil.log("OS: [Mac OSX]");
            operatingSystem = OperatingSystem.MACOSX;
        } else {
            LoggingUtil.log("OS: [Unix]");
            operatingSystem = OperatingSystem.UNIX;
        }
        return operatingSystem;
    }

    public void runTests(File file) throws IOException {
        if (this.headless) {
            CommandFactory.createHeadlessStart(this.xcommand);
        }
        PlayerCommand playerCommand = CommandFactory.createPlayer(this.os, this.player, this.localTrusted);
        playerCommand.setProject(this.project);
        playerCommand.setSwf(file);
        LoggingUtil.log("Launching player:\n" + playerCommand.describe());
        playerCommand.execute();
        if (this.snapshot) {
            CommandFactory.createSnapshot(this.headless, this.xcommand);
        }
        if (this.headless) {
            CommandFactory.createHeadlessStop(this.xcommand);
        }
    }
}

