/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.flexunit.ant.LoggingUtil;

public class FlexUnitSocketServer {
    private static final char NULL_BYTE = '\u0000';
    private static final String POLICY_FILE_REQUEST = "<policy-file-request/>";
    private static final String DOMAIN_POLICY = "<?xml version=\"1.0\"?><cross-domain-policy xmlns=\"http://localhost\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.adobe.com/xml/schemas PolicyFileSocket.xsd\"><allow-access-from domain=\"*\" to-ports=\"{0}\" /></cross-domain-policy>";
    private static final String START_OF_TEST_RUN_ACK = "<startOfTestRunAck/>";
    private static final String END_OF_TEST_RUN = "<endOfTestRun/>";
    private static final String END_OF_TEST_RUN_ACK = "<endOfTestRunAck/>";
    private int port;
    private int timeout;
    private int inboundBufferSize;
    private boolean waitForPolicyFile;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private BufferedInputStream inboundStream = null;
    private OutputStream outboundStream = null;

    public FlexUnitSocketServer(int n, int n2, int n3, boolean bl) {
        this.port = n;
        this.timeout = n2;
        this.inboundBufferSize = n3;
        this.waitForPolicyFile = bl;
    }

    public void start() throws IOException {
        LoggingUtil.log("Starting server ...");
        try {
            this.openServerSocket();
            this.openClientSocket();
            this.prepareClientSocket();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new BuildException("Socket timeout waiting for flexunit report", (Throwable)socketTimeoutException);
        }
    }

    private void resetInboundStream() throws IOException {
        LoggingUtil.log("Resetting client connection ...");
        this.closeClientSocket();
        this.openClientSocket();
    }

    private void openServerSocket() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.serverSocket.setSoTimeout(this.timeout);
        LoggingUtil.log("Opening server socket on port [" + this.port + "].");
    }

    private void openClientSocket() throws IOException {
        LoggingUtil.log("Waiting for client connection ...");
        this.clientSocket = this.serverSocket.accept();
        LoggingUtil.log("Client connected.");
        LoggingUtil.log("Setting inbound buffer size to [" + this.inboundBufferSize + "] bytes.");
        this.inboundStream = new BufferedInputStream(this.clientSocket.getInputStream(), this.inboundBufferSize);
        this.outboundStream = new BufferedOutputStream(this.clientSocket.getOutputStream());
        LoggingUtil.log("Receiving data ...");
    }

    private void prepareClientSocket() throws IOException {
        String string;
        if (this.waitForPolicyFile && (string = this.readNextTokenFromSocket()).equals(POLICY_FILE_REQUEST)) {
            LoggingUtil.log("Policy file requested.");
            this.sendPolicyFile();
            this.resetInboundStream();
        }
        this.sendTestRunStartAcknowledgement();
    }

    private void sendPolicyFile() throws IOException {
        this.sendOutboundMessage(MessageFormat.format(DOMAIN_POLICY, Integer.toString(this.port)));
        LoggingUtil.log("Policy file sent.");
    }

    private void sendTestRunStartAcknowledgement() throws IOException {
        LoggingUtil.log("Sending acknowledgement to player to start sending test data ...\n");
        this.sendOutboundMessage(START_OF_TEST_RUN_ACK);
    }

    public String readNextTokenFromSocket() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        while ((n = this.inboundStream.read()) != 0) {
            if (n == -1) {
                return null;
            }
            char c = (char)n;
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        if (string.equals(END_OF_TEST_RUN)) {
            return null;
        }
        return string;
    }

    private void sendOutboundMessage(String string) throws IOException {
        if (this.outboundStream != null) {
            this.outboundStream.write(string.getBytes());
            this.outboundStream.write(0);
            this.outboundStream.flush();
        }
    }

    public void stop() throws IOException {
        LoggingUtil.log("\nStopping server ...");
        this.sendTestRunEndAcknowledgement();
        this.closeClientSocket();
        this.closeServerSocket();
    }

    private void sendTestRunEndAcknowledgement() throws IOException {
        LoggingUtil.log("End of test data reached, sending acknowledgement to player ...");
        this.sendOutboundMessage(END_OF_TEST_RUN_ACK);
    }

    private void closeClientSocket() throws IOException {
        LoggingUtil.log("Closing client connection ...");
        if (this.outboundStream != null) {
            this.outboundStream.close();
        }
        if (this.inboundStream != null) {
            this.inboundStream.close();
        }
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
    }

    private void closeServerSocket() throws IOException {
        LoggingUtil.log("Closing server on port [" + this.port + "] ...");
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }
}

