////////////////////////////////////////////////////////////////////////
// Arduino BlueSMiRF initial baudrate changer
// 
// This is example code provided by NeuroSky, Inc. and is provided
// license free.
//
// * Connect BlueSMiRF RX and TX to Serial on Arduino board (pins 0 & 1)
// * Connect BlueSMiRF VCC to the pin corresponding to BLUESMIRFON
// * 
////////////////////////////////////////////////////////////////////////

#define LED 13
#define BLUESMIRFON 7
#define FACTORYRESET 0

#if FACTORYRESET
  #define BAUDRATE 57600
#else
  #define BAUDRATE 115200
#endif

char str[3];
char mac[13] = "0013EF00077A";
char passkey[5] = "0000";

boolean success = false;

void setup() 
{ 
  //Initialize pins
  pinMode(LED, OUTPUT);
  pinMode(BLUESMIRFON, OUTPUT);

  //Initialize serial ports
  Serial.begin(BAUDRATE);   

  digitalWrite(BLUESMIRFON, HIGH);  
  delay(2000);			        //Wait for BlueSMIRF to turn on

  Serial.print('$');			//Send command to put BlueSMIRF into programming mode
  Serial.print('$');
  Serial.print('$');
  
  delay(100);
  Serial.flush();
  
   //Reset the module
#if FACTORYRESET
  Serial.print('S');
  Serial.print('F');
  Serial.print(',');
  Serial.print('1');
  Serial.print('\r');  
  
  while(Serial.available() < 3);
  str[0] = (char)Serial.read();
  str[1] = (char)Serial.read();
  str[2] = (char)Serial.read();  
  if(str[0] == 'A' && str[1] == 'O' && str[2] == 'K')
    success = true;
  Serial.flush();
#else
  //Set the baudrate
  Serial.print('S');
  Serial.print('U');
  Serial.print(',');
  Serial.print('5');
  Serial.print('7');
  Serial.print('\r');  
  
  while(Serial.available() < 3);
  str[0] = (char)Serial.read();
  str[1] = (char)Serial.read();
  str[2] = (char)Serial.read();  
  if(str[0] == 'A' && str[1] == 'O' && str[2] == 'K')
    success = true;
  Serial.flush();
  
  //Set the remote MAC address
  Serial.print('S');
  Serial.print('R');
  Serial.print(',');
  for(int i = 0; i < 12; i++) {
    Serial.print(mac[i]);
  }
  Serial.print('\r');  
  
  while(Serial.available() < 3);
  str[0] = (char)Serial.read();
  str[1] = (char)Serial.read();
  str[2] = (char)Serial.read();  
  if(str[0] == 'A' && str[1] == 'O' && str[2] == 'K')
    success = true;
  else
    success = false;
  Serial.flush();
  
  //Set the passkey
  Serial.print('S');
  Serial.print('P');
  Serial.print(',');
  for(int i = 0; i < 4; i++) {
    Serial.print(passkey[i]);
  }
  Serial.print('\r');  
  
  while(Serial.available() < 3);
  str[0] = (char)Serial.read();
  str[1] = (char)Serial.read();
  str[2] = (char)Serial.read();  
  if(str[0] == 'A' && str[1] == 'O' && str[2] == 'K')
    success = true;
  else
    success = false;    
  Serial.flush(); 
  
  //Set the BlueSMiRF mode
  Serial.print('S');
  Serial.print('M');
  Serial.print(',');
  Serial.print('3');
  Serial.print('\r');
  
  while(Serial.available() < 3);
  str[0] = (char)Serial.read();
  str[1] = (char)Serial.read();
  str[2] = (char)Serial.read();  
  if(str[0] == 'A' && str[1] == 'O' && str[2] == 'K')
    success = true;
  else
    success = false;  
  Serial.flush();
  
  delay(100);
  //Exit command mode
#endif  
  Serial.print('-');
  Serial.print('-');
  Serial.print('-');
  Serial.print('\r');
} 

void loop() {   
  if(success) {
    digitalWrite(LED,LOW);
    delay(1000);
    digitalWrite(LED,HIGH);
    delay(1000);
  }
} 






